% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createlms.R
\name{do_iterations}
\alias{do_iterations}
\title{do lms iterations}
\usage{
do_iterations(data.list, n = 10, max.it = 1000, prop.fam = 0.75,
  prop.subject = 1, age.min = 0, age.max = 18, age.int = 1/12,
  keep.models = F, dist = "BCCGo", mu.df = 4, sigma.df = 3, nu.df = 2,
  tau.df = 2, verbose = F, trans.x = F, lim.trans = c(0, 1.5))
}
\arguments{
\item{data.list}{list of dataframes as returned by prepare_data}

\item{n}{number of desired fits}

\item{max.it}{maximum number of iterations that will be run}

\item{prop.fam}{proportion of families to be sampled}

\item{prop.subject}{proportion of subject to be sampled}

\item{age.min}{lower bound of age}

\item{age.max}{upper bound of age}

\item{age.int}{stepwidth of the age variable}

\item{keep.models}{indicator whether or not models in each iteration should be kept}

\item{dist}{distribution used for the fitting process, has to be one of BCCGo, BCPEo, BCTo as they are accepted by lms()}

\item{mu.df}{degree of freedem location parameter}

\item{sigma.df}{degree of freedem spread parameter}

\item{nu.df}{degree of freedem skewness parameter}

\item{tau.df}{degree of freedem kurtosis parameter}

\item{verbose}{whether or not information about sampling will be printed during while iterate}

\item{trans.x}{indicator wether age should be transformed or not}

\item{lim.trans}{limits for the exponent of transformation of age}
}
\value{
list of lists for models and fitted parameters
}
\description{
Do lms iterations
}
\details{
function samples families, samples measurements (and subjects), fits the model for a
given number of iterations
}
\author{
Mandy Vogel
}
