% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-gte.R
\name{chk_gte}
\alias{chk_gte}
\alias{vld_gte}
\title{Check Greater Than or Equal To}
\usage{
chk_gte(x, value = 0, x_name = NULL)

vld_gte(x, value = 0)
}
\arguments{
\item{x}{The object to check.}

\item{value}{A non-missing scalar of a value.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if all non-missing values are greater than or equal to y using

\code{all(x[!is.na(x)] >= value)}
}
\section{Functions}{
\itemize{
\item \code{vld_gte}: Validate Greater Than or Equal To
}}

\examples{

# chk_gte
chk_gte(0)
try(chk_gte(-0.1))

# vld_gte
vld_gte(numeric(0))
vld_gte(0)
vld_gte(-0.1)
vld_gte(c(0.1, 0.2, NA))
vld_gte(c(0.1, 0.2, NA), value = 1)
}
\seealso{
Other chk_ranges: 
\code{\link{chk_gt}()},
\code{\link{chk_lte}()},
\code{\link{chk_lt}()},
\code{\link{chk_range}()}
}
\concept{chk_ranges}
