% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-match.R
\name{chk_match}
\alias{chk_match}
\alias{vld_match}
\title{Check Matches}
\usage{
chk_match(x, regexp = ".+", x_name = NULL)

vld_match(x, regexp = ".+")
}
\arguments{
\item{x}{The object to check.}

\item{regexp}{A string of a regular expression.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if all values match regular expression using

\code{all(grepl(regexp, x[!is.na(x)]))}
}
\section{Functions}{
\itemize{
\item \code{vld_match}: Validate Matches
}}

\examples{
# chk_match
chk_match("1")
try(chk_match("1", regexp = "2"))
# vld_match
vld_match("1")
vld_match("a", regexp = "a")
vld_match("")
vld_match("1", regexp = "2")
vld_match(NA_character_, regexp = ".*")
}
\seealso{
Other chk_misc: 
\code{\link{chk_length}()},
\code{\link{chk_named}()},
\code{\link{chk_not_any_na}()},
\code{\link{chk_not_empty}()},
\code{\link{chk_sorted}()},
\code{\link{chk_unique}()},
\code{\link{chk_valid_name}()}
}
\concept{chk_misc}
