% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caseLocator.R
\name{caseLocator}
\alias{caseLocator}
\title{Locate case by numerical ID.}
\usage{
caseLocator(case = 1, zoom = 1, observed = TRUE, add.title = TRUE,
  highlight.segment = TRUE, data = FALSE, add = FALSE, col = "red")
}
\arguments{
\item{case}{Numeric or Integer. Whole number between 1 and 578.}

\item{zoom}{Logical or Numeric.A numeric value >= 0 controls the degree of zoom. The default is 1.}

\item{observed}{Logical. \code{TRUE} for observed. \code{FALSE} for simulated.}

\item{add.title}{Logical. Include title.}

\item{highlight.segment}{Logical. Highlight case's segment.}

\item{data}{Logical. Output data.}

\item{add}{Logical. Add to existing plot or separate plot.}

\item{col}{Character. Point color.}
}
\value{
A base R graphics plot.
}
\description{
Highlight selected observed or simulated case and its home road segment.
}
\examples{
caseLocator(290)
caseLocator(290, zoom = TRUE)
caseLocator(290, observed = FALSE)
}
