% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walking.R
\name{plot.walking}
\alias{plot.walking}
\title{Plot method for neighborhoodWalking().}
\usage{
\method{plot}{walking}(x, type = "roads", msg = FALSE, ...)
}
\arguments{
\item{x}{An object of class "walking" created by \code{neighborhoodWalking()}.}

\item{type}{Character. "roads", "area.points" or "area.polygons". "area" flavors only valid when \code{case.set = "expected"}.}

\item{msg}{Logical. Toggle in-progress messages.}

\item{...}{Additional plotting parameters.}
}
\value{
A base R plot.
}
\description{
Plot method for neighborhoodWalking().
}
\note{
When plotting area graphs with simulated data (i.e., \code{case.set = "expected"}), there may be discrepancies between observed cases and expected neighborhoods, particularly between neighborhoods.
}
\examples{
\dontrun{
plot(neighborhoodWalking())
plot(neighborhoodWalking(case.set = "expected"))
plot(neighborhoodWalking(case.set = "expected"), type = "area.points")
plot(neighborhoodWalking(case.set = "expected"), type = "area.polygons")
}
}
