% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{roads}
\alias{roads}
\title{Dodson and Tobler's street data with appended road names.}
\format{
A data frame with 206 observations and 5 variables. The data describe the roads on Snow's map.
\describe{
  \item{\code{street}}{street segment number, which range between 1 and 528}
  \item{\code{n}}{number of points in this street line segment}
  \item{\code{x}}{x-coordinate}
  \item{\code{y}}{y-coordinate}
  \item{\code{id}}{unique numeric ID}
  \item{\code{name}}{road name}
  \item{\code{lon}}{longitude}
  \item{\code{lat}}{latitude}
}
}
\usage{
roads
}
\description{
This data set adds road names from John Snow's map to Dodson and Tobler's street data. The latter are also available from HistData::Snow.streets.
}
\seealso{
\code{\link{road.segments}}

\code{vignette}("road.names")

\code{\link{streetNameLocator}}

\code{\link{streetNumberLocator}}

\code{\link{segmentLocator}}
}
\keyword{datasets}
