% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pumpFatalities.R
\name{pumpFatalities}
\alias{pumpFatalities}
\title{Compute fatalities by pump.}
\usage{
pumpFatalities(pump.select = NULL, metric = "walking", vestry = FALSE,
  latlong = FALSE, multi.core = FALSE)
}
\arguments{
\item{pump.select}{Numeric. Pump candidates to consider. Default is \code{NULL}: all pumps are used. Otherwise, selection by a vector of numeric IDs: 1 to 13 for \code{pumps}; 1 to 14 for \code{pumps.vestry}. Negative selection allowed.}

\item{metric}{Character. "euclidean" or "walking".}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry Report. \code{FALSE} uses the 13 in the original map.}

\item{latlong}{Logical. Use estimated longitude and latitude.}

\item{multi.core}{Logical or Numeric. \code{TRUE} uses \code{parallel::detectCores()}. \code{FALSE} uses one, single core. You can also specify the number logical cores. See \code{vignette("Parallelization")} for details.}
}
\description{
Compute fatalities by pump.
}
\examples{
\dontrun{
pumpFatalities(pump.select = -7)
pumpFatalities(latlong = TRUE)
pumpFatalities(metric = "euclidean", vestry = TRUE)
}
}
