% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streetNameLocator.R
\name{streetNameLocator}
\alias{streetNameLocator}
\title{Locate street(s) by name(s).}
\usage{
streetNameLocator(street.name = "Broad Street", zoom = TRUE,
  latlong = FALSE, cases = "address", token = "id", vestry = FALSE,
  add.pump = TRUE, add.title = TRUE, add.subtitle = TRUE,
  highlight = TRUE, distance.unit = "meter", time.unit = "second",
  walking.speed = 5, cex.text = 0.67)
}
\arguments{
\item{street.name}{Character. A street name or vector of street names (e.g., "Broad Street", "Poland Street").}

\item{zoom}{Logical or Numeric. Positive numbers zoom in; negative numbers zoom out.}

\item{latlong}{Logical. Longitude and latitude coordinates}

\item{cases}{Character. Cases to plot: \code{NULL}, "address" or "fatality".}

\item{token}{Character. Cases as "id" or "point".}

\item{vestry}{Logical. \code{TRUE} uses the 14 pumps from the Vestry report. \code{FALSE} uses the 13 in the original map.}

\item{add.pump}{Logical. Include pumps.}

\item{add.title}{Logical. Include title.}

\item{add.subtitle}{Logical. Include subtitle.}

\item{highlight}{Logical. Highlight selected segment(s) and cases.}

\item{distance.unit}{Character. Unit of distance: "meter", "yard" or "native". "native" returns the map's native scale. See \code{vignette("roads")} for information on conversion.}

\item{time.unit}{Character. "hour", "minute", or "second".}

\item{walking.speed}{Numeric. Walking speed in km/hr.}

\item{cex.text}{Numeric.}
}
\value{
A base R graphics plot.
}
\description{
Highlight selected road(s) and cases.
}
\note{
See \code{streetNames()}.
}
\examples{
streetNameLocator("broad street")
streetNameLocator("Broad Street", zoom = -10)
streetNameLocator("Broad Street", latlong = TRUE, zoom = -10)
streetNameLocator("Broad Street", distance.unit = "yard")
streetNameLocator("Broad Street", zoom = FALSE)
}
