% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_quantile_lm.R
\name{add_quantile.lm}
\alias{add_quantile.lm}
\title{Quantiles for the Response of a Linear Model}
\usage{
\method{add_quantile}{lm}(
  df,
  fit,
  p,
  name = NULL,
  yhatName = "pred",
  log_response = FALSE,
  ...
)
}
\arguments{
\item{df}{A data frame of new data.}

\item{fit}{An object of class \code{lm}. Predictions are made with
this object.}

\item{p}{A real number between 0 and 1. Sets the level of the
quantiles.}

\item{name}{\code{NULL} or a string. If \code{NULL},
quantiles automatically will be named by \code{add_quantile},
otherwise, they will be named \code{name}.}

\item{yhatName}{A string. Name of the vector of predictions.}

\item{log_response}{A logical. If TRUE, quantiles will be generated
for the prediction made with a log-linear model: \eqn{\log(Y) =
X\beta + \epsilon}. These quantiles will be on the scale of the
original response, \eqn{Y}.}

\item{...}{Additional arguments.}
}
\value{
A dataframe, \code{df}, with predicted values and level -
    \emph{p} quantiles attached.
}
\description{
This function is one of the methods of \code{add_quantile}. It is
called automatically when \code{add_quantile} is called on objects
of class \code{lm}.
}
\details{
Quantiles for linear models are determined parametrically, by
applying a pivotal quantity to the distribution of \eqn{Y|x}.
}
\examples{

# Fit a linear Model
fit <- lm(dist ~ speed, data = cars)

# Find the 0.7-quantile (70th percentile) of new distances, given
# the linear model fit.
add_quantile(cars, fit, p = 0.7)

# As above, but with a custom name for the vector of quantiles
add_quantile(cars, fit, p = 0.7, name = "my_quantile")

}
\seealso{
\code{\link{add_ci.lm}} for confidence intervals for
    \code{lm} objects, \code{\link{add_pi.lm}} for prediction
    intervals of \code{lm} objects, and \code{\link{add_probs.lm}}
    for response probabilities of \code{lm} objects.
}
