% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extendr-wrappers.R
\name{parseGraph}
\alias{parseGraph}
\title{Obtain an internal representation of a CIfly graph.}
\usage{
parseGraph(graph, ruletable, tableAsString = FALSE)
}
\arguments{
\item{graph}{A list mapping edge types to edge lists.}

\item{ruletable}{Path to a ruletable file.}

\item{tableAsString}{Optional argument to enable passing the ruletable as multi-line string. Default value is FALSE.}
}
\value{
Internal CIfly graph representation.
}
\description{
Obtain an internal representation of a CIfly graph. Advanced usage only, mostly recommended for improving performance if the same graph is used multiple times. The parsed graph object can be passed to all methods with a graph argument. It is compatible with all ruletables that have the same \verb{EDGES ...} line as the ruletable passed as argument.
}
\examples{
dsepTable <- "
    EDGES --> <--
    SETS X, Z
    START <-- AT X
    OUTPUT ...
    --> | <-- | current in Z
    ... | ... | current not in Z
"
edgelist <- list("-->" = rbind(c(1, 2), c(3, 2), c(2, 4)))

g <- parseGraph(edgelist, dsepTable, tableAsString=TRUE)
sets <- list("X" = c(1), "Z" = c(4))
reach(edgelist, sets, dsepTable, tableAsString=TRUE)
}
