% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{preprocess}
\alias{preprocess}
\title{Preprocess Function}
\usage{
preprocess(
  df,
  samplesize = NA,
  numeric_operation_list = c("mean"),
  categories = NULL,
  target = NA,
  target_agg = "mean",
  verbose = TRUE
)
}
\arguments{
\item{df}{data.frame, the data to preprocess}

\item{samplesize}{numeric, the fraction of ids used to create a sub-sample of the input df}

\item{numeric_operation_list}{list, a list of the aggregation functions to apply to numeric columns}

\item{categories}{list, a list of the categorical columns to aggregate}

\item{target}{character, the column to use as a response variable for supervised learning}

\item{target_agg}{character, the aggregation function to use to aggregate the target column}

\item{verbose}{logical whether information about the preprocessing should be given}
}
\value{
An id attributes data frame, e.g. customer attributes if the id represents customer IDs. 
A single row per unique id.
}
\description{
Transforms a transactional table into an id aggregated table with custom options for aggregation methods for numeric and categorical columns.
}
