% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/civis_future.R
\name{CivisFuture}
\alias{CivisFuture}
\title{Evaluate an expression in Civis Platform}
\usage{
CivisFuture(expr = NULL, envir = parent.frame(), substitute = FALSE,
  globals = TRUE, packages = NULL, lazy = FALSE, local = TRUE,
  gc = FALSE, earlySignal = FALSE, label = NULL,
  required_resources = list(cpu = 1024, memory = 2048, diskSpace = 4),
  docker_image_name = "civisanalytics/datascience-r",
  docker_image_tag = "2.3.0", ...)
}
\arguments{
\item{expr}{An R \link[base]{expression}.}

\item{envir}{The \link{environment} in which the evaluation
is done (or inherits from if \code{local} is TRUE).}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{globals}{(optional) a named list of global objects needed in order
for the future to be resolved correctly.}

\item{packages}{(optional) a character vector specifying packages
to be attached in the R environment evaluating the future.}

\item{lazy}{If \code{FALSE} (default), the future is resolved
eagerly (starting immediately), otherwise not.}

\item{local}{If TRUE, the expression is evaluated such that
all assignments are done to local temporary environment, otherwise
the assignments are done to the global environment of the \R process
evaluating the future.}

\item{gc}{If TRUE, the garbage collector run (in the process that
evaluated the future) after the value of the future is collected.
\emph{Some types of futures ignore this argument.}}

\item{earlySignal}{Specified whether conditions should be signaled
as soon as possible or not.}

\item{label}{An optional character string label attached to the
future.}

\item{required_resources}{resources, see \code{\link{scripts_post_containers}}}

\item{docker_image_name}{the image for the container script.}

\item{docker_image_tag}{the tag for the Docker image.}

\item{...}{arguments to \code{\link{scripts_post_containers}}}
}
\value{
A \code{CivisFuture} inheriting from \code{\link{Future}} that evaluates \code{expr} on the given container.
}
\description{
Evaluate an expression in Civis Platform
}
