% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{scripts_list_custom}
\alias{scripts_list_custom}
\title{List Custom Scripts}
\usage{
scripts_list_custom(
  from_template_id = NULL,
  author = NULL,
  status = NULL,
  hidden = NULL,
  archived = NULL,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{from_template_id}{string optional. If specified, return scripts based on the template with this ID. Specify multiple IDs as a comma-separated list.}

\item{author}{string optional. If specified, return items from this author. Must use user IDs. A comma separated list of IDs is also accepted to return items from multiple authors.}

\item{status}{string optional. If specified, returns items with one of these statuses. It accepts a comma-separated list, possible values are 'running', 'failed', 'succeeded', 'idle', 'scheduled'.}

\item{hidden}{boolean optional. If specified to be true, returns hidden items. Defaults to false, returning non-hidden items.}

\item{archived}{string optional. The archival status of the requested item(s).}

\item{limit}{integer optional. Number of results to return. Defaults to its maximum of 50.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to updated_at. Must be one of: updated_at, name, created_at.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to asc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID for the script.}
\item{name}{string, The name of the script.}
\item{type}{string, The type of the script (e.g Custom)}
\item{createdAt}{string, The time this script was created.}
\item{updatedAt}{string, The time the script was last updated.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{state}{string, The status of the script's last run.}
\item{finishedAt}{string, The time that the script's last run finished.}
\item{projects}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID for the project.
\item name string, The name of the project.
}}
\item{parentId}{integer, The ID of the parent job that will trigger this script}
\item{fromTemplateId}{integer, The ID of the template script.}
\item{timeZone}{string, The time zone of this script.}
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
\item{archived}{string, The archival status of the requested item(s).}
\item{lastSuccessfulRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
}}
}
\description{
List Custom Scripts
}
