% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvsl_weights.R
\name{cvsl_weights}
\alias{cvsl_weights}
\title{Create a table of meta-weights from a CV.SuperLearner}
\usage{
cvsl_weights(cvsl, sort = T, nonzero = F, clean_names = T, rank = T,
  digits = 5)
}
\arguments{
\item{cvsl}{CV.SuperLearner result object}

\item{sort}{If TRUE, sort rows (learners) in descending order by mean weight.}

\item{nonzero}{Restrict to learners with a non-zero mean weight.}

\item{clean_names}{Remove "SL." from the front and "_All" from the end of
learner names.}

\item{rank}{Adding the learner rank to the table.}

\item{digits}{Number of digits to round the results. Set to NULL to disable.}
}
\value{
Table in data frame form with each learner's mean, sd, min, and max
  meta-weight in the ensemble of each learner.
}
\description{
Returns summary statistics (mean, sd, min, max) on the
  distribution of the weights assigned to each learner across SuperLearner
  ensembles. This makes it easier to understand the stochastic nature of the
  SL learner weights and to see how often certain learners are used. This
  function may eventually be moved into the SuperLearner package.
}
\examples{
library(SuperLearner)
library(ck37r)

data(Boston, package = "MASS")

set.seed(1, "L'Ecuyer-CMRG")

# Subset rows to speed up example computation.
row_subset = sample(nrow(Boston), 100)

Boston = Boston[row_subset, ]
X = subset(Boston, select = -chas)

cvsl = CV.SuperLearner(Boston$chas, X[, 1:2], family = binomial(),
                      cvControl = list(V = 2, stratifyCV = TRUE),
                      SL.library = c("SL.mean", "SL.glm"))
cvsl_weights(cvsl)

}
\references{
Polley EC, van der Laan MJ (2010) Super Learner in Prediction. U.C. Berkeley
Division of Biostatistics Working Paper Series. Paper 226.
http://biostats.bepress.com/ucbbiostat/paper266/

van der Laan, M. J., Polley, E. C. and Hubbard, A. E. (2007) Super Learner.
Statistical Applications of Genetics and Molecular Biology, 6, article 25.
http://www.degruyter.com/view/j/sagmb.2007.6.issue-1/sagmb.2007.6.1.1309/sagmb.2007.6.1.1309.xml
}
