% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/user_activity_list.R
\name{user_activity_list}
\alias{user_activity_list}
\title{Return a list of a user's activities}
\usage{
user_activity_list(id, offset = 0, limit = 31, url = get_default_url(),
  as = "list", ...)
}
\arguments{
\item{id}{(character) User identifier.}

\item{offset}{(numeric) Where to start getting activity items from (optional, default: 0)}

\item{limit}{(numeric) The maximum number of activities to return (optional, default: 31)}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[httr]{POST}} (optional)}
}
\description{
Return a list of a user's activities
}
\examples{
\dontrun{
# Setup
ckanr_setup(url = "http://demo.ckan.org/", key = getOption("ckan_demo_key"))

# list package activity
user_activity_list('sckottie')

# input a ckan_user object
(x <- user_show('sckottie'))
user_activity_list(x)

# output different data formats
user_activity_list(x, as = "table")
user_activity_list(x, as = "json")
}
}

