% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resource_search.R
\name{resource_search}
\alias{resource_search}
\title{Search for resources.}
\usage{
resource_search(
  q,
  sort = NULL,
  offset = NULL,
  limit = NULL,
  url = get_default_url(),
  key = get_default_key(),
  as = "list",
  ...
)
}
\arguments{
\item{q}{Query terms. It is a string of the form \code{field:term} or a
vector/list of strings, each of the same form.  Within each string, \code{field}
is a field or extra field on the Resource domain object. If \code{field} is
hash, then an attempt is made to match the \code{term} as a \emph{prefix} of the
Resource.hash field. If \code{field} is an extra field, then an attempt is
made to match against the extra fields stored against the Resource.}

\item{sort}{Field to sort on. You can specify ascending (e.g., score desc)
or descending (e.g., score asc), sort by two fields (e.g., score desc,
price asc), or sort by a function (e.g., sum(x_f, y_f) desc, which sorts
by the sum of x_f and y_f in a descending order).}

\item{offset}{Record to start at, default to beginning.}

\item{limit}{Number of records to return.}

\item{url}{Base url to use. Default: \url{http://data.techno-science.ca}. See
also \code{\link{ckanr_setup}} and \code{\link{get_default_url}}.}

\item{key}{A privileged CKAN API key, Default: your key set with \code{\link{ckanr_setup}}}

\item{as}{(character) One of list (default), table, or json. Parsing with table option
uses \code{jsonlite::fromJSON(..., simplifyDataFrame = TRUE)}, which attempts to parse
data to data.frame's when possible, so the result can vary from a vector, list or
data.frame. (required)}

\item{...}{Curl args passed on to \code{\link[crul]{verb-POST}} (optional)}
}
\description{
Search for resources.
}
\examples{
\dontrun{
resource_search(q = 'name:data')
resource_search(q = 'name:data', as = 'json')
resource_search(q = 'name:data', as = 'table')
resource_search(q = 'name:data', limit = 2, as = 'table')
resource_search(q=c("description:encoded", "name:No.2"),url='demo.ckan.org')
}
}
