% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{cnlp_utils_tfidf}
\alias{cnlp_utils_tfidf}
\alias{cnlp_utils_tf}
\title{Construct the TF-IDF Matrix from Annotation or Data Frame}
\usage{
cnlp_utils_tfidf(
  object,
  tf_weight = c("lognorm", "binary", "raw", "dnorm"),
  idf_weight = c("idf", "smooth", "prob", "uniform"),
  min_df = 0.1,
  max_df = 0.9,
  max_features = 10000,
  doc_var = "doc_id",
  token_var = "lemma",
  vocabulary = NULL,
  doc_set = NULL
)

cnlp_utils_tf(
  object,
  tf_weight = "raw",
  idf_weight = "uniform",
  min_df = 0,
  max_df = 1,
  max_features = 10000,
  doc_var = "doc_id",
  token_var = "lemma",
  vocabulary = NULL,
  doc_set = NULL
)
}
\arguments{
\item{object}{a data frame containing an identifier for the document
(set with \code{doc_var}) and token (set with
\code{token_var})}

\item{tf_weight}{the weighting scheme for the term frequency matrix.
The selection \code{lognorm} takes one plus
the log of the raw frequency (or zero if zero),
\code{binary} encodes a zero one matrix
indicating simply whether the token exists at all
in the document, \code{raw} returns raw counts,
and \code{dnorm} uses double normalization.}

\item{idf_weight}{the weighting scheme for the inverse document
matrix. The selection \code{idf} gives the
logarithm of the simple inverse frequency,
\code{smooth} gives the logarithm of one plus
the simple inverse frequency, and \code{prob}
gives the log odds of the the token occurring
in a randomly selected document. Set to \code{uniform}
to return just the term frequencies.}

\item{min_df}{the minimum proportion of documents a token
should be in to be included in the vocabulary}

\item{max_df}{the maximum proportion of documents a token
should be in to be included in the vocabulary}

\item{max_features}{the maximum number of tokens in the vocabulary}

\item{doc_var}{character vector. The name of the column in
\code{object} that contains the document ids. Defaults
to "doc_id".}

\item{token_var}{character vector. The name of the column in
\code{object} that contains the tokens. Defaults to
"lemma".}

\item{vocabulary}{character vector. The vocabulary set to use in
constructing the matrices. Will be computed
within the function if set to \code{NULL}. When
supplied, the options \code{min_df}, \code{max_df},
and \code{max_features} are ignored.}

\item{doc_set}{optional character vector of document ids. Useful to
create empty rows in the output matrix for documents
without data in the input. Most users will want to keep
this equal to \code{NULL}, the default, to have the
function compute the document set automatically.}
}
\value{
a sparse matrix with dimnames giving the documents and vocabular.
}
\description{
Given annotations, this function returns the term-frequency inverse
document frequency (tf-idf) matrix from the extracted lemmas.
}
