% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_traversal_util.R
\name{recursiveDepthBinning}
\alias{recursiveDepthBinning}
\title{Recursive Depth Binning}
\usage{
recursiveDepthBinning(node_list, depth, expected_num_children, binned_depths)
}
\arguments{
\item{node_list}{Must be in the format of elements in the Ranger package's
forest$split.varIDs, which represents one tree in the forest.
Recursion is done by counting the number of terminal nodes at the current
depth to anticipate the correct number of nodes at the next depth.}

\item{depth}{Each recursive call must know the current depth in the tree.}

\item{expected_num_children}{The number of nodes in the current depth must
be anticipated, given the number of terminal nodes at the previous depth.}

\item{binned_depths}{A list passed between recursive calls, to store
results.}
}
\value{
A list of vectors, where elements correspond to depths,
and vectors contain variable ID's of variables used to split at that depth.
}
\description{
Function to recursively traverse depths of a tree.
}

