% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotbetas.R
\name{plotbetas}
\alias{plotbetas}
\title{Plot model beta estimates}
\usage{
plotbetas(dataset, arrow = FALSE, plotallenv, plotall = FALSE)
}
\arguments{
\item{dataset}{A dataframe containing information on all fitted climate 
windows. Output from \code{\link{slidingwin}}.}

\item{arrow}{TRUE or FALSE. Add arrows to plots to pinpoint best window.}

\item{plotallenv}{Used in conjunction with function \code{\link{plotall}}.
Should not be changed manually.}

\item{plotall}{Used in conjunction with function \code{\link{plotall}}. 
Should not be changed manually.}
}
\value{
Returns colour plots of model beta estimates. Where applicable, 2nd 
order coefficients (quadratic) and 3rd order coefficients (cubic) will be 
plotted separately.
}
\description{
Create colour plots of model beta estimates. Will include quadratic and cubic
beta estimates where appropriate.
}
\examples{
# Plot model beta estimates for linear models in the Mass dataset

data(MassOutput)

plotbetas(dataset = MassOutput)

}
\author{
Liam D. Bailey and Martijn van de Pol
}
