\name{summary.emaxsimBobj}
\alias{summary.emaxsimBobj}

\title{Summarize Emax fit to a data set generated by emaxsimB }
\description{
 Summary of the Bayesian Emax fit to a simulated data
set}

\usage{
\method{summary}{emaxsimBobj}(object, ...)
}

\arguments{
  \item{object}{Extracted simulation object }
  \item{\dots}{No other parameters are currently implemented }
}

\value{
Printed output only.  No values are returned.
}

\author{Neal Thomas }

\seealso{ \code{\link{emaxsimB}}, 
\code{\link{plot.emaxsimBobj}}, \code{\link{print.emaxsimBobj}} }
\examples{

\dontrun{

## emaxsimB changes the random number seed
nsim<-50
doselev<-c(0,5,25,50,100)
n<-c(78,81,81,81,77)
Ndose<-length(doselev)

### population parameters for simulation
e0<-2.465375 
ed50<-67.481113 
emax<-4.127726
sdy<-7.967897
pop<-c(log(ed50),emax,e0)    
meanlev<-emaxfun(doselev,pop)  

###FixedMean is specialized constructor function for emaxsim
gen<-FixedMean(n,doselev,meanlev,sdy)  

prior<-prior.control(epmu=0,epsd=30,emaxmu=0,emaxsd=30,p50=50,sigmalow=0.1,
		sigmaup=30,edDF=5)
mcmc<-mcmc.control(chains=1,warmup=500,iter=5000,seed=53453,propInit=0.15,adapt_delta = 0.95)

D1 <- emaxsimB(nsim,gen, prior, modType=3,mcmc=mcmc,check=FALSE)
summary(D1[1])
}
}
\keyword{nonlinear}

