% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_baseline_scr.R
\name{calc_baseline_scr}
\alias{calc_baseline_scr}
\title{Calculate baseline sCr}
\usage{
calc_baseline_scr(
  baseline_scr,
  scr,
  times,
  method,
  first_dose_time = NULL,
  verbose
)
}
\arguments{
\item{baseline_scr}{baseline serum creatinine method (character). See calc_aki_stage() for availabloptions.}

\item{scr}{serum creatinine in mg/dL. Use `convert_creat()` to convert from
mmol/L. Values below the detection limit ("<0.2") will be converted to
numeric (0.2)}

\item{times}{creatinine sample times in hours}

\item{method}{classification method, one of `KDIGO`, `RIFLE`, `pRIFLE` (case insensitive)}

\item{first_dose_time}{time in hours of first dose relative to sCr value, used for calculate baseline serum creatinine in `median_before_treatment` approach.}

\item{verbose}{verbose (`TRUE` or `FALSE`)}
}
\description{
Calculate baseline sCr
}
