% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nca.R
\name{nca}
\alias{nca}
\title{Perform an NCA based on a NONMEM-style dataset}
\usage{
nca(data = NULL, dose = 100, tau = 6, method = "log_linear",
  scale = list(auc = 1, conc = 1), dv_min = 0.001)
}
\arguments{
\item{data}{data.frame with time and dv columns}

\item{dose}{dose amount}

\item{tau}{dosing frequency}

\item{method}{`log_linear` or `linear`}

\item{scale}{list with scaling for auc and concentration (`conc`)}

\item{dv_min}{minimum concentrations, lower observations will be set to this value}
}
\description{
Perform an NCA based on a NONMEM-style dataset
}
\examples{
data <- data.frame(time = c(0, 2, 4, 6, 8, 12, 16),
                   dv   = c(0, 10, 14, 11, 9, 5, 1.5))
nca(data)
}
