/*
 * Decompiled with CFR 0.152.
 */
package rreval;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.LocalPortForwarder;
import ch.ethz.ssh2.SCPClient;
import java.io.File;
import java.io.IOException;
import nbl.utilj.StringUtil;
import rreval.AppCmd;
import rreval.Verbose;
import utilssh.ConnectFailureException;
import utilssh.Ssh;

public class SshWrangler {
    public static long SSH_WAIT_TIME = 5000L;
    String hostName;
    String userName;
    File pemFile;
    int portLocal;
    int portRemote;
    Connection conPF;
    LocalPortForwarder portForwarder;
    Connection conSCP;
    SCPClient scpClient;

    public SshWrangler(String hostName, String userName, File pemFile, int portLocal, int portRemote) throws IOException, ConnectFailureException {
        this.hostName = hostName;
        this.userName = userName;
        this.pemFile = pemFile;
        this.portLocal = portLocal;
        this.portRemote = portRemote;
    }

    public void startPortForwarding() throws ConnectFailureException, IOException {
        this.conPF = Ssh.connect((String)this.hostName, (String)this.userName, (File)this.pemFile, (long)SSH_WAIT_TIME);
        this.portForwarder = this.conPF.createLocalPortForwarder(this.portLocal, "localhost", this.portRemote);
        Verbose.show("SshWrangler: started port forwarding to " + this.userName + "@" + this.hostName + " ports " + this.portLocal + " -> " + this.portRemote);
    }

    public void setupScp() throws ConnectFailureException, IOException {
        Verbose.show("SshWrangler: about to setup scp: " + this.hostName + " " + this.userName + " " + this.pemFile.getPath());
        this.conSCP = Ssh.connect((String)this.hostName, (String)this.userName, (File)this.pemFile, (long)SSH_WAIT_TIME);
        this.scpClient = new SCPClient(this.conSCP);
        Verbose.show("SshWrangler: setup scp client to " + this.userName + "@" + this.hostName);
    }

    String scpUpload(AppCmd cmd) throws IOException {
        if (this.scpClient == null) {
            return "scp has not been setup yet.";
        }
        String localFileS = cmd.getVal(Arg.localFile.toString());
        if (localFileS == null) {
            return "Local file was not specified.";
        }
        File localFile = new File(localFileS);
        if (!localFile.exists()) {
            return "Local file " + localFile.getPath() + " does not exist.";
        }
        String remoteDirS = cmd.getVal(Arg.remoteDir.toString());
        if (remoteDirS == null) {
            return "Remote dir was not specified.";
        }
        ScpPut sp = new ScpPut(localFile, remoteDirS);
        new Thread(sp).start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ix) {
            // empty catch block
        }
        if (sp.iox == null) {
            if (sp.done) {
                return "Uploaded " + localFile.getPath() + " to " + this.hostName + ":" + remoteDirS;
            }
            return "Uploading " + localFile.getPath() + " to " + this.hostName + ":" + remoteDirS;
        }
        throw sp.iox;
    }

    String scpDownload(AppCmd cmd) throws IOException {
        if (this.scpClient == null) {
            return "scp has not been setup yet.";
        }
        String remoteFileS = cmd.getVal(Arg.remoteFile.toString());
        if (remoteFileS == null) {
            return "Remote file was not specified.";
        }
        String localDirS = cmd.getVal(Arg.localDir.toString());
        if (localDirS == null) {
            return "Local dir was not specified.";
        }
        File localDir = new File(localDirS);
        if (!localDir.exists() || !localDir.isDirectory()) {
            return localDir.getPath() + " does not exist or is not a directory.";
        }
        ScpGet sp = new ScpGet(remoteFileS, localDir);
        new Thread(sp).start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ix) {
            // empty catch block
        }
        if (sp.iox == null) {
            if (sp.done) {
                return "Downloaded " + this.hostName + ":" + remoteFileS + " to " + localDir.getPath();
            }
            return "Downloading " + this.hostName + ":" + remoteFileS + " to " + localDir.getPath();
        }
        throw sp.iox;
    }

    void shutdown() throws IOException {
        if (this.conPF != null) {
            this.conPF.close();
        }
        this.portForwarder = null;
        this.conPF = null;
        if (this.conSCP != null) {
            this.conSCP.close();
        }
        this.scpClient = null;
        this.conSCP = null;
    }

    class ScpGet
    implements Runnable {
        String remoteFileS;
        File localDir;
        IOException iox;
        boolean done;

        ScpGet(String remoteFileS, File localDir) {
            this.remoteFileS = remoteFileS;
            this.localDir = localDir;
            this.iox = null;
            this.done = false;
        }

        @Override
        public void run() {
            block2: {
                try {
                    SshWrangler.this.scpClient.get(this.remoteFileS, this.localDir.getPath());
                    this.done = true;
                }
                catch (Exception xxx) {
                    System.err.println(StringUtil.toString((Throwable)xxx));
                    if (!(xxx instanceof IOException)) break block2;
                    this.iox = (IOException)xxx;
                }
            }
        }
    }

    class ScpPut
    implements Runnable {
        File localFile;
        String remoteDirS;
        IOException iox;
        boolean done;

        ScpPut(File localFile, String remoteDirS) {
            this.localFile = localFile;
            this.remoteDirS = remoteDirS;
            this.iox = null;
            this.done = false;
        }

        @Override
        public void run() {
            block2: {
                try {
                    SshWrangler.this.scpClient.put(this.localFile.getPath(), this.remoteDirS);
                    this.done = true;
                }
                catch (Exception xxx) {
                    System.err.println(StringUtil.toString((Throwable)xxx));
                    if (!(xxx instanceof IOException)) break block2;
                    this.iox = (IOException)xxx;
                }
            }
        }
    }

    static enum Arg {
        localFile,
        localDir,
        remoteFile,
        remoteDir;

    }
}

