/*
 * Decompiled with CFR 0.152.
 */
package ppe.gui.networkspec;

import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.Image;
import java.awt.EventQueue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ppe.ec2.AmiDescription;
import ppe.ec2.Ec2InstanceType;
import ppe.ec2.Ec2Wrangler;
import ppe.ec2.NetworkSpec;
import ppe.ec2.NiM;
import ppe.gui.InProgressFrame;
import ppe.gui.networkspec.AmiChoice;
import ppe.gui.networkspec.AvailabilityZoneChoice;
import ppe.gui.networkspec.Choice;
import ppe.gui.networkspec.ChoiceSet;
import ppe.gui.networkspec.InstanceTypeChoice;
import ppe.gui.networkspec.KeyPairChoice;
import ppe.gui.networkspec.NInstancesChoice;
import ppe.gui.networkspec.NetworkNameChoice;
import ppe.gui.networkspec.NetworkSpecGuiFrame;
import ppe.gui.networkspec.SecurityGroupChoice;
import ppe.gui.networkspec.SlotsPerHostChoice;
import ppe.gui.networkspec.SpotPriceCC;
import ppe.gui.networkspec.SpotPriceChoice;
import ppe.ompi.OmpiSpec;

public class NetworkSpecGui {
    Ec2Wrangler ec2w;
    List<Image> images;
    List<Ec2InstanceType> instanceTypes;
    List<String> keypairNames;
    boolean specComplete;
    public NetworkSpec spec;
    public OmpiSpec specOmpi;
    ChoiceSet instanceTypeChoices;
    ChoiceSet amiChoices;
    ChoiceSet availabilityZoneChoices;
    ChoiceSet securityGroupChoices;
    ChoiceSet keyPairsChoices;
    SpotPriceChoice spotPriceChoice;
    NInstancesChoice nInstancesChoice;
    NetworkNameChoice networkNameChoice;
    SlotsPerHostChoice slotsPerHostChoice;
    public NetworkSpecGuiFrame networkSpecFrame;

    public NetworkSpecGui(Ec2Wrangler ec2w, NetworkSpec spec, OmpiSpec specOmpi) throws FileNotFoundException, IOException {
        this.ec2w = ec2w;
        this.spec = spec.cloneSpec();
        this.specOmpi = specOmpi.cloneSpec();
        this.images = AmiDescription.getSupportedImages(ec2w.ec2Client);
        this.instanceTypes = Ec2InstanceType.getInstanceTypes();
        this.keypairNames = ec2w.getKeypairNames();
        this.createChoices();
    }

    void createChoices() {
        Choice c;
        Choice c2;
        this.instanceTypeChoices = new ChoiceSet();
        for (Ec2InstanceType eit : this.instanceTypes) {
            this.instanceTypeChoices.add(new InstanceTypeChoice(eit));
        }
        if (this.spec.instanceType != null && (c2 = this.instanceTypeChoices.getChoiceOrNull(this.spec.instanceType.toString())) != null) {
            c2.setSelected(true);
        }
        this.amiChoices = new ChoiceSet();
        for (Image img : this.images) {
            this.amiChoices.add(new AmiChoice(img, this.ec2w.ec2Client));
        }
        AmiChoice paramSpecifiedAmi = null;
        if (this.spec.imageID != null) {
            c = this.amiChoices.getChoiceOrNull(this.spec.imageID);
            if (c != null) {
                c.setSelected(true);
                paramSpecifiedAmi = (AmiChoice)c;
            } else {
                AmiChoice other = (AmiChoice)this.amiChoices.get(this.amiChoices.size() - 1);
                other.setSelected(true);
                other.value = this.spec.imageID;
                paramSpecifiedAmi = other;
            }
        }
        this.availabilityZoneChoices = new ChoiceSet();
        this.createZoneChoices(paramSpecifiedAmi);
        this.keyPairsChoices = new ChoiceSet();
        for (String kp : this.keypairNames) {
            this.keyPairsChoices.add(new KeyPairChoice(kp));
        }
        this.keyPairsChoices.add(new KeyPairChoice());
        if (this.spec.keyName != null && (c = this.keyPairsChoices.getChoiceOrNull(this.spec.keyName)) != null) {
            c.setSelected(true);
        }
        this.securityGroupChoices = new ChoiceSet();
        this.securityGroupChoices.add(new SecurityGroupChoice(SecurityGroupChoice.Type.defaultGroup));
        this.securityGroupChoices.add(new SecurityGroupChoice(SecurityGroupChoice.Type.other));
        this.spotPriceChoice = new SpotPriceChoice();
        this.nInstancesChoice = new NInstancesChoice();
        this.networkNameChoice = this.spec.networkName == null ? new NetworkNameChoice(NiM.createUniqueDefaultNetworkName()) : new NetworkNameChoice(this.spec.networkName);
        this.slotsPerHostChoice = this.specOmpi.slotsPerHost > 0 ? new SlotsPerHostChoice(this.specOmpi.slotsPerHost) : new SlotsPerHostChoice();
    }

    public boolean fillSpec() {
        this.specComplete = false;
        this.networkSpecFrame = new NetworkSpecGuiFrame(this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NetworkSpecGui.this.networkSpecFrame.create();
                InProgressFrame.end();
            }
        });
        while (this.networkSpecFrame.notDone) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.specComplete;
    }

    public String checkSpec() {
        String ni;
        KeyPairChoice kp;
        SecurityGroupChoice sg;
        AmiChoice ami;
        ArrayList<String> missing = new ArrayList<String>();
        ArrayList<String> invalid = new ArrayList<String>();
        InstanceTypeChoice instanceType = (InstanceTypeChoice)this.instanceTypeChoices.getSelected();
        if (instanceType == null) {
            missing.add("Instance type");
        }
        if ((ami = (AmiChoice)this.amiChoices.getSelected()) == null) {
            missing.add("AMI ID");
        }
        if ((sg = (SecurityGroupChoice)this.securityGroupChoices.getSelected()) == null) {
            missing.add("Security group");
        }
        if ((kp = (KeyPairChoice)this.keyPairsChoices.getSelected()) == null || kp.getValue() == null) {
            missing.add("Keypair");
        }
        if (this.spotPriceChoice.selected) {
            String x = (String)this.spotPriceChoice.getValue();
            if (this.isEmpty(x)) {
                missing.add("Spot price");
            } else if (this.isInvalidPrice(x)) {
                invalid.add("'" + x + "' is not a valid price.");
            }
        }
        if (this.isEmpty(ni = (String)this.nInstancesChoice.getValue())) {
            missing.add("n instances");
        } else if (this.isInvalidNInstances(ni)) {
            invalid.add("'" + ni + "' is not a valid number of instances.");
        }
        String networkName = (String)this.networkNameChoice.getValue();
        if (this.isEmpty(networkName)) {
            missing.add("Network name");
        }
        if (this.slotsPerHostChoice.getValue() == null) {
            missing.add("Slots per host");
        }
        if (missing.size() < 1 && invalid.size() < 1) {
            return null;
        }
        StringBuilder s = new StringBuilder("<html>\n");
        if (missing.size() > 0) {
            s.append("The following required parameters were not specified:<ul>\n");
            for (String m : missing) {
                s.append("<li>" + m + "</li>\n");
            }
            s.append("</ul>\n");
        }
        if (invalid.size() > 0) {
            s.append("<br>");
            s.append("Invalid values:<ul>\n");
            for (String i : invalid) {
                s.append("<li>" + i + "</li>\n");
            }
            s.append("</ul>\n");
        }
        s.append("</html>");
        return s.toString();
    }

    public NetworkSpec choicesToNetworkSpec() {
        KeyPairChoice kp;
        AvailabilityZoneChoice az;
        AmiChoice ami;
        NetworkSpec s = new NetworkSpec();
        InstanceTypeChoice instanceType = (InstanceTypeChoice)this.instanceTypeChoices.getSelected();
        if (instanceType != null) {
            s.instanceType = instanceType.instanceType.instanceType;
        }
        if ((ami = (AmiChoice)this.amiChoices.getSelected()) != null) {
            s.imageID = (String)ami.getValue();
        }
        s.availabilityZone = (az = (AvailabilityZoneChoice)this.availabilityZoneChoices.getSelected()) != null ? az.getLabel() : "Use any zone.";
        SecurityGroupChoice sg = (SecurityGroupChoice)this.securityGroupChoices.getSelected();
        if (sg != null) {
            s.securityGroupName = (String)sg.getValue();
        }
        if ((kp = (KeyPairChoice)this.keyPairsChoices.getSelected()) != null) {
            s.keyName = (String)kp.getValue();
        }
        if (this.spotPriceChoice.selected) {
            s.useSpotInstances = true;
            s.spotPrice = this.spotPriceChoice.getPrice();
        } else {
            s.useSpotInstances = false;
        }
        s.nInstances = this.nInstancesChoice.getNInstances();
        s.networkName = (String)this.networkNameChoice.getValue();
        return s;
    }

    public OmpiSpec choicesToOmpiSpec() {
        OmpiSpec s = new OmpiSpec();
        s.networkName = (String)this.networkNameChoice.getValue();
        s.slotsPerHost = this.slotsPerHostChoice.getNSlots();
        InstanceTypeChoice instanceType = (InstanceTypeChoice)this.instanceTypeChoices.getSelected();
        if (instanceType != null) {
            s.instanceType = instanceType.instanceType.instanceType;
        }
        s.rsaKeyPairFile = this.specOmpi.rsaKeyPairFile;
        s.disableHyperthreading = this.specOmpi.disableHyperthreading;
        return s;
    }

    String toHtmlString() {
        NetworkSpec ns = this.choicesToNetworkSpec();
        if (!ns.isComplete()) {
            throw new RuntimeException("Incomplete NetworkSpec:<br>" + ns.listMissingParams());
        }
        OmpiSpec os = this.choicesToOmpiSpec();
        if (!os.isComplete()) {
            throw new RuntimeException("Incomplete OmpiSpec:<br>" + ns.listMissingParams());
        }
        StringBuilder s = new StringBuilder("<html><b>ec2 network specification:</b><br><ul>");
        s.append("<li>Instance type:  " + ns.instanceType + "</li>");
        s.append("<li>AMI ID:  " + ns.imageID + "</li>");
        s.append("<li>Availability zone: " + ns.availabilityZone + "</li");
        s.append("<li>Security group:  " + ns.securityGroupName + "</li>");
        s.append("<li>Keypair:  " + ns.keyName + "</li>");
        if (ns.useSpotInstances) {
            s.append("<li>Spot price:  " + ns.spotPrice + "</li>");
        }
        s.append("<li>N instances:  " + ns.nInstances + "</li>");
        s.append("<li>Slots per host:  " + os.slotsPerHost + "</li>");
        s.append("</ul><br><b>Please note that if you proceed you will incur charges from Amazon for ec2 instances.</b><br><br></html>");
        return s.toString();
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().length() < 1;
    }

    private boolean isInvalidPrice(String s) {
        try {
            double p = Double.parseDouble(s);
            return p <= 0.0;
        }
        catch (NumberFormatException nfx) {
            return true;
        }
    }

    private boolean isInvalidNInstances(String s) {
        try {
            double n = Integer.parseInt(s);
            return n <= 0.0;
        }
        catch (NumberFormatException nfx) {
            return true;
        }
    }

    public Choice getChoice(String choiceType, String label) {
        if (this.instanceTypeChoices.hasChoiceType(choiceType)) {
            return this.instanceTypeChoices.getChoice(label);
        }
        if (this.amiChoices.hasChoiceType(choiceType)) {
            return this.amiChoices.getChoice(label);
        }
        if (this.securityGroupChoices.hasChoiceType(choiceType)) {
            return this.securityGroupChoices.getChoice(label);
        }
        if (this.keyPairsChoices.hasChoiceType(choiceType)) {
            return this.keyPairsChoices.getChoice(label);
        }
        if (this.spotPriceChoice.getChoiceType().equals(choiceType)) {
            return this.spotPriceChoice;
        }
        if (this.nInstancesChoice.getChoiceType().equals(choiceType)) {
            return this.nInstancesChoice;
        }
        if (this.networkNameChoice.getChoiceType().equals(choiceType)) {
            return this.networkNameChoice;
        }
        if (this.slotsPerHostChoice.getChoiceType().equals(choiceType)) {
            return this.slotsPerHostChoice;
        }
        if (this.availabilityZoneChoices.hasChoiceType(choiceType)) {
            return this.availabilityZoneChoices.getChoice(label);
        }
        throw new RuntimeException("Unknown choice className: " + choiceType);
    }

    private List<Choice> getChoices(String choiceType) {
        ArrayList<Choice> chs = new ArrayList<Choice>();
        if (this.instanceTypeChoices.hasChoiceType(choiceType)) {
            return this.instanceTypeChoices;
        }
        if (this.amiChoices.hasChoiceType(choiceType)) {
            return this.amiChoices;
        }
        if (this.securityGroupChoices.hasChoiceType(choiceType)) {
            return this.securityGroupChoices;
        }
        if (this.keyPairsChoices.hasChoiceType(choiceType)) {
            return this.keyPairsChoices;
        }
        if (this.spotPriceChoice.getChoiceType().equals(choiceType)) {
            chs.add(this.spotPriceChoice);
            return chs;
        }
        if (this.nInstancesChoice.getChoiceType().equals(choiceType)) {
            chs.add(this.nInstancesChoice);
            return chs;
        }
        if (this.networkNameChoice.getChoiceType().equals(choiceType)) {
            chs.add(this.networkNameChoice);
            return chs;
        }
        if (this.slotsPerHostChoice.getChoiceType().equals(choiceType)) {
            chs.add(this.slotsPerHostChoice);
            return chs;
        }
        if (this.availabilityZoneChoices.hasChoiceType(choiceType)) {
            return this.availabilityZoneChoices;
        }
        throw new RuntimeException("Unknown choice className: " + choiceType);
    }

    public void updateRe(String choiceType, String label) {
        Choice c = this.getChoice(choiceType, label);
        List<Choice> choices = this.getChoices(choiceType);
        if (choices.size() > 1) {
            for (Choice x : choices) {
                x.setSelected(false);
            }
        }
        c.setSelected(true);
        if (c instanceof InstanceTypeChoice) {
            this.imposeConformityReInstanceTypeChoice((InstanceTypeChoice)c);
            this.slotsPerHostChoice.setNSlots(((InstanceTypeChoice)c).instanceType.nCores);
        } else if (c instanceof AmiChoice) {
            new CreateZoneChoicesAndSetSpotPriceChoice((AmiChoice)c).start();
        }
    }

    void createZoneChoices(AmiChoice amiChoice) {
        if (amiChoice != null && amiChoice.image != null && amiChoice.image.getImageId() != null) {
            String ami = amiChoice.image.getImageId();
            if (ami == null) {
                return;
            }
            this.availabilityZoneChoices.clear();
            List<AvailabilityZone> zones = AmiDescription.getAvailabilityZones(this.ec2w.ec2Client, ami);
            this.availabilityZoneChoices.add(new AvailabilityZoneChoice(null));
            for (AvailabilityZone z : zones) {
                this.availabilityZoneChoices.add(new AvailabilityZoneChoice(z));
            }
            for (Choice c : this.availabilityZoneChoices) {
                c.setEnabled(true);
            }
        } else {
            this.availabilityZoneChoices.clear();
            this.availabilityZoneChoices.add(new AvailabilityZoneChoice(null));
            for (AvailabilityZone z : this.ec2w.ec2Client.describeAvailabilityZones().getAvailabilityZones()) {
                this.availabilityZoneChoices.add(new AvailabilityZoneChoice(z));
            }
            for (Choice c : this.availabilityZoneChoices) {
                c.setEnabled(false);
            }
        }
    }

    void setSpotPriceChooserReAmiChoice(AmiChoice amiChoice) {
        if (amiChoice.isDevPay() && ((SpotPriceCC)this.spotPriceChoice.cc).isPopulated()) {
            this.spotPriceChoice.depopulateCC(this.networkSpecFrame);
        } else if (!amiChoice.isDevPay() && !((SpotPriceCC)this.spotPriceChoice.cc).isPopulated()) {
            this.spotPriceChoice.repopulateCC(this.networkSpecFrame);
        }
    }

    void imposeConformityReInstanceTypeChoice(InstanceTypeChoice c) {
        if (!c.cc.getRadioButton().isSelected()) {
            return;
        }
        if (c.instanceType.isHvm()) {
            this.imposeHvmConformity(c);
        } else if (c.instanceType.isPv()) {
            this.imposeParavirtualConformity(c);
        } else {
            throw new RuntimeException("Bad instance type=" + c.instanceType.instanceType.toString() + " " + (Object)((Object)c.instanceType.vt));
        }
    }

    void imposeHvmConformity(InstanceTypeChoice selected) {
        for (Choice c : this.amiChoices) {
            AmiChoice a = (AmiChoice)c;
            if (a.usesParavirtual()) {
                a.cc.setSelected(false);
                a.cc.setEnabled(false);
                continue;
            }
            a.cc.setEnabled(true);
        }
    }

    void imposeParavirtualConformity(Choice selected) {
        for (Choice c : this.amiChoices) {
            AmiChoice a = (AmiChoice)c;
            if (a.usesHvm()) {
                a.cc.setSelected(false);
                a.cc.setEnabled(false);
                continue;
            }
            a.cc.setEnabled(true);
        }
        this.spotPriceChoice.setEnabled(true);
    }

    class CreateZoneChoices
    extends Thread {
        AmiChoice c;

        CreateZoneChoices(AmiChoice c) {
            this.c = c;
        }

        @Override
        public void run() {
            InProgressFrame.showInProgress();
            NetworkSpecGui.this.createZoneChoices(this.c);
            InProgressFrame.end();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NetworkSpecGui.this.networkSpecFrame.buildZoneMenu();
                }
            });
        }
    }

    class CreateZoneChoicesAndSetSpotPriceChoice
    extends Thread {
        AmiChoice c;

        CreateZoneChoicesAndSetSpotPriceChoice(AmiChoice c) {
            this.c = c;
        }

        @Override
        public void run() {
            InProgressFrame.showInProgress();
            NetworkSpecGui.this.createZoneChoices(this.c);
            InProgressFrame.end();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NetworkSpecGui.this.networkSpecFrame.buildZoneMenu();
                    NetworkSpecGui.this.setSpotPriceChooserReAmiChoice(CreateZoneChoicesAndSetSpotPriceChoice.this.c);
                }
            });
        }
    }
}

