/*
 * Decompiled with CFR 0.152.
 */
package ppe.ompi;

import ch.ethz.ssh2.Connection;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ppe.ExceptionHandler;
import ppe.UtilPPE;
import ppe.ec2.Ec2InstanceType;
import ppe.ec2.Ec2Wrangler;
import ppe.ec2.HyperthreadDisabler;
import ppe.ec2.NetworkInfo;
import ppe.ec2.NiM;
import ppe.ompi.Constants;
import ppe.ompi.OmpiSpec;
import ppe.util.SshCp;
import utilssh.Ssh;
import utilssh.SshExec;
import utilssh.SshPingFailureException;

public class OmpiConfig {
    State state;
    Ec2Wrangler ec2w;
    OmpiSpec spec;

    public OmpiConfig(Ec2Wrangler ec2w, OmpiSpec spec) {
        this.ec2w = ec2w;
        this.spec = spec;
        this.state = State.nil;
    }

    private void setState(State state) {
        this.state = state;
        NiM.fireStateChangeEvent();
    }

    public boolean isPending() {
        return !State.isConfigured.equals((Object)this.state) && !State.notConfigured.equals((Object)this.state);
    }

    public boolean isConfigured() {
        return State.isConfigured.equals((Object)this.state);
    }

    public String getName() {
        return "open-mpi";
    }

    public String getStateDescription() {
        return this.state.getTitle();
    }

    public int getPort() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean config(String networkID) {
        boolean bl;
        block12: {
            NetworkInfo ni = NiM.getForID(networkID);
            HashMap htc = null;
            try {
                this.setState(State.configuring);
                String master = this.ec2w.getMasterPublicDns(ni);
                List<String> slaves = this.ec2w.getSlavesPublicDns(ni);
                this.setState(State.pingingHosts);
                ArrayList<String> hosts = new ArrayList<String>();
                hosts.add(master);
                hosts.addAll(slaves);
                this.state.appendToTitle(" n=" + Integer.toString(hosts.size()));
                this.waitForAllHostsToRespond(hosts);
                this.setState(State.connectingToInstances);
                htc = Ssh.connect(hosts, (String)ppe.ec2.Constants.EC2_USERNAME, (File)this.spec.rsaKeyPairFile, (long)10000L, (long)600000L);
                this.setState(State.configuringIntraNetworkAccess);
                CmdExecutor sxMaster = new CmdExecutor((Connection)htc.get(master));
                SshCp scp = new SshCp();
                sxMaster.createRSAKeypair();
                String publicKeyFilename = Constants.PPE_MASTER_KEY_PAIR_FILENAME + ".pub";
                scp.cp(htc, slaves, master, ppe.ec2.Constants.EC2_USER_SSH_DIR, publicKeyFilename);
                for (String slave : slaves) {
                    SshExec sx = new SshExec((Connection)htc.get(slave));
                    sx.exec("cd " + ppe.ec2.Constants.EC2_USER_SSH_DIR + " ; " + "cat " + publicKeyFilename + " >> " + Constants.AUTHORIZED_KEYS_FILENAME);
                }
                this.setState(State.creatingHostfile);
                ArrayList<String> hostNames = new ArrayList<String>();
                hostNames.add(master);
                hostNames.addAll(slaves);
                File hostFile = this.createHostFile(hostNames);
                scp.cp((Connection)htc.get(master), ppe.ec2.Constants.EC2_USER_HOME_DIR, hostFile);
                hostFile.delete();
                if (this.spec.disableHyperthreading) {
                    this.setState(State.disablingHyperthreading);
                    Ec2InstanceType iit = Ec2InstanceType.getInstanceInfo(this.spec.instanceType);
                    if (iit == null) {
                        throw new RuntimeException("iit == null");
                    }
                    for (String host : hostNames) {
                        HyperthreadDisabler htd = new HyperthreadDisabler();
                        SshExec sx = new SshExec((Connection)htc.get(host));
                        htd.disable(sx, iit.nCores);
                    }
                }
                this.setState(State.isConfigured);
                bl = true;
                if (htc == null) break block12;
            }
            catch (SshPingFailureException px) {
                this.setState(State.pingFailed);
                ExceptionHandler.text(px);
                boolean bl2 = false;
                return bl2;
            }
            catch (Exception xxx) {
                this.setState(State.notConfigured);
                ExceptionHandler.text(xxx);
                boolean bl3 = false;
                return bl3;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (htc != null) {
                    Ssh.closeConnections(htc);
                }
            }
            Ssh.closeConnections((HashMap)htc);
        }
        return bl;
    }

    private void waitForAllHostsToRespond(List<String> hosts) throws SshPingFailureException {
        ArrayList<String> failures = new ArrayList<String>();
        for (String h : hosts) {
            try {
                Ssh.waitForPingSsh((String)h, (long)utilssh.Constants.MAX_WAIT_FOR_SSH_PING);
            }
            catch (SshPingFailureException px) {
                failures.add(h);
            }
        }
        if (failures.size() > 0) {
            String s = new String();
            for (String h : failures) {
                s = s + h + " ";
            }
            throw new SshPingFailureException("Failed to contact hosts: " + s.trim());
        }
    }

    private File createHostFile(List<String> hostNames) throws IOException {
        StringBuilder s = new StringBuilder();
        s.append("# " + Constants.OMPI_HOSTFILE_NAME + "\n\n");
        for (String host : hostNames) {
            s.append(host + " slots=" + Integer.toString(this.spec.slotsPerHost) + "\n");
        }
        String txt = s.toString();
        File tmpDir = UtilPPE.getTmpDir(ppe.Constants.TMP_DIR);
        File hostfile = new File(tmpDir, Constants.OMPI_HOSTFILE_NAME);
        FileWriter fw = new FileWriter(hostfile);
        fw.write(txt);
        fw.flush();
        fw.close();
        return hostfile;
    }

    private File constructRemoteRSAKeyPairFile() {
        return new File("/home/" + ppe.ec2.Constants.EC2_USERNAME + "/.ssh/" + Constants.PPE_MASTER_KEY_PAIR_FILENAME);
    }

    private File constructRemoteOmpiHistFile() {
        return new File("/home/" + ppe.ec2.Constants.EC2_USERNAME + "/" + Constants.OMPI_HOSTFILE_NAME);
    }

    class CmdExecutor
    extends SshExec {
        CmdExecutor(Connection connection) throws IOException {
            super(connection);
        }

        public String createRSAKeypair() throws IOException {
            String dir = ppe.ec2.Constants.EC2_USER_SSH_DIR;
            String fn = Constants.PPE_MASTER_KEY_PAIR_FILENAME;
            String cmd = "cd " + dir + "; " + "ssh-keygen -t rsa -f " + fn + " -P '';";
            return this.exec(cmd);
        }
    }

    public static enum State {
        nil("-"),
        configuring("configuring ompi"),
        connectingToInstances("connecting to instances"),
        pingingHosts("pinging hosts"),
        pingFailed("Ping failed"),
        configuringIntraNetworkAccess("configuring intra-network access"),
        creatingHostfile("creating hostfile"),
        disablingHyperthreading("disabling hyperthreading"),
        isConfigured("configured"),
        notConfigured("not configured");

        String title;

        private State(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public void appendToTitle(String a) {
            this.title = this.title + a;
        }
    }
}

