% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoring_functions_Rcpp.R
\name{expansion}
\alias{expansion}
\title{Expansion}
\usage{
expansion(g, com)
}
\arguments{
\item{g}{Graph to be analyzed (as an \code{igraph} object). If the edges have a "weight"
attribute, those will be used as weights.}

\item{com}{community membership integer vector. Each element corresponds to a vertex.}
}
\value{
Numeric vector with the expansion of each community.
}
\description{
Given a graph (possibly weighted) split into communities, the expansion of a community
is the sum of all edge weights connecting it to the rest of the graph divided by the number
of vertices in the community
}
\examples{
data(karate, package="igraphdata")
expansion(karate, membership(cluster_louvain(karate)))
}
\seealso{
Other cluster scoring functions: 
\code{\link{FOMD}()},
\code{\link{average_degree}()},
\code{\link{average_odf}()},
\code{\link{conductance}()},
\code{\link{coverage}()},
\code{\link{cut_ratio}()},
\code{\link{density_ratio}()},
\code{\link{edges_inside}()},
\code{\link{internal_density}()},
\code{\link{max_odf}()},
\code{\link{normalized_cut}()},
\code{\link{weighted_clustering_coefficient}()},
\code{\link{weighted_transitivity}()}
}
\concept{cluster scoring functions}
