% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{gen_traj_data}
\alias{gen_traj_data}
\title{Data Generators}
\usage{
gen_traj_data(
  n_id,
  m_obs,
  s_range,
  e_range,
  reference = 100,
  noise = c(0, abs(reference/20)),
  min_obs = 3
)
}
\arguments{
\item{n_id}{Vector whose length is the number of clusters, giving the number of id's to
generate in each cluster.}

\item{m_obs}{Mean number of observation per id. Provides \code{lambda} parameter in
\code{\link[stats]{rpois}}.}

\item{s_range}{A vector of length 2, giving the min and max limits of uniformly generated
start observation time.}

\item{e_range}{A vector of length 2, giving the min and max limits of uniformly generated
end observation time.}

\item{reference}{A nominal response value (for example, blood pressure is near 100, which
is the default)}

\item{noise}{Vector of length 2 giving the \emph{mean} and \emph{sd} of added N(mean, sd) noise.}

\item{min_obs}{Minimum number of observations in addition to zero time observation.}
}
\value{
A data table with one response per row and four columns:
\code{id}, \code{time}, \code{response}, and \code{true_group}.
}
\description{
Generates a collection of longitudinal responses with possibly varying
lengths and varying numbers of observations. Support is
\code{start} . . . 0 . . . \code{end}, where
\code{start}~uniform(s_range) and \code{end}~uniform(e_range), so that
all trajectories are aligned at 0 but can start and end at different times.
Zero is the intervention time.
}
\section{Details}{

Generate longitudinal data for a response variable. Trajectories start
at time uniformly distributed in s_range and end at time uniformly
distributed in e_range. Number of observations in a trajectory is
Poisson(m_obs). The result is a number of trajectories, all starting at
time 0, with different time spans, and with independently different numbers
of observations within the time spans. Each trajectory follows a randomly
selected response function with added N(mean, sd) error.
}

\examples{
data = gen_traj_data(n_id = c(50, 100), m_obs = 20, s_range = c(-365, -14),
              e_range = c(0.5*365, 2*365))
head(data)
tail(data)

}
