% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_instat_plot.R
\name{render_instat_plot}
\alias{render_instat_plot}
\title{Creating a simple instat plot.}
\usage{
render_instat_plot(
  co.data,
  shortDescription,
  grid_col,
  bordercolor,
  linesize,
  ylab
)
}
\arguments{
\item{co.data}{Statistics given to hist plot (data.frame).}

\item{shortDescription}{A title will be generated using "Comparison of" + description (character).}

\item{grid_col}{Color used for the grid.}

\item{bordercolor}{Color used for borders.}

\item{linesize}{Line width to be used (positive numeric).}

\item{ylab}{Label for y axis (character).}
}
\description{
This function creates a simple r-instat plot.
}
\examples{
co.data <- list(
  lon_station = c(1,2,3),
  lat_station = c(10,20,30),
  data_station = c(1,2,3),
  data_sat = c(4,3,2)
)

render_instat_plot(
  co.data = co.data,
  shortDescription = "thing 1 vs thing 2",
  grid_col = "cornsilk2",
  bordercolor = "gray20",
  linesize = 1.2,
  ylab = "y label"
)

}
