% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/feature_size_change.R
\name{feat_size_change}
\alias{feat_size_change}
\title{Adds an instantaneous change of the population size of one
population to a model.}
\usage{
feat_size_change(new_size, population, time = "0")
}
\arguments{
\item{new_size}{A \code{\link{parameter}} giving the new size of the
population, as a factor of N0.}

\item{population}{The number of the population whose size is changed.}

\item{time}{The time point at which the size changes.}
}
\value{
A feature which can be added to a model.
}
\description{
This function changes the effective population size of one
population. The change is performed at a given time point
and applies to the time interval further on into
the past from this point. The population size is set to a
fraction of N0, the present day size of population one.
}
\details{
If you want to add a slow, continuous change over some time,
then use \link{feat_growth}.
}
\examples{
# A model with one smaller population
model <- coal_model(c(20,37), 88) +
  feat_size_change(.1, 2, time="1")
}

