% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sumstat_nsl.R
\name{sumstat_nSL}
\alias{sumstat_nSL}
\title{Number  of  Segregating  Sites  by  Length}
\usage{
sumstat_nSL(name = "ihh", position = NA, population = 1,
  max_snps = 10000)
}
\arguments{
\item{name}{The name of the summary statistic. When simulating a model,
the value of the statistics are written to an entry of the returned list
with this name. Summary statistic names must be unique in a model.}

\item{position}{A position relative to the locus extent, e.g. 0.5 for the
middle of the locus. If provided, the statistic will be calculate
for the SNP closest to the given position.
Otherwise, it will be calculated for all SNPs.
The position is relative to the middle locus" extend if trios
are used.}

\item{population}{The population for which the statistic is calculated.}

\item{max_snps}{The maximal number of SNPs per locus that are used for the
calculation. If a locus has more SNPs than this number, only a
evenly distributed subset of this size will be used for calculating iHS
to increase performance. Set to \code{Inf} to use all SNPs.}
}
\value{
When added to a model, the statistic returns a vector for each locus,
  which lists the values of nSL either for all SNPs when no position is
  given or for the SNP nearest to the selected position.
  SNPs are sorted by their positions on the locus.
}
\description{
This (mis)uses \code{\link[rehh]{scan_hh}} from package \pkg{rehh} to
calculate the nSL statistic from
}
\details{
Ferrer-Admetlla et al., On Detecting Incomplete Soft or Hard Selective
Sweeps Using Haplotype Structure. Mol Biol Evol (2014) 31 (5): 1275-1291.
doi:10.1093/molbev/msu077

It uses the package \pkg{rehh} to calculate iHS with distances between
SNPs measured in SNPs rather than in physical or genetic distance, which
should result in nSL.
It is required to install the package \pkg{rehh} to use this function.
}

