% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_recombination.R
\name{feat_recombination}
\alias{feat_recombination}
\title{Feature: Recombination}
\usage{
feat_recombination(rate)
}
\arguments{
\item{rate}{A \code{\link{parameter}} defining the recombination rate
(see above).}
}
\value{
The demographic model with recombination
}
\description{
Adds intra-locus recombination to a model.
}
\details{
The corresponding rate parameter is 4*N0*r, where r is the
probability that a recombination event within the locus will
occur in one generation. Even when using an infinite sites
mutation model, this assumes an finite locus length.
}
\examples{
# A model with a fixed recombination rate of 5
model <- coal_model(c(25,25), 100, 1000) +
  feat_recombination(5)
}

