% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_ignore_singletons.R
\name{feat_ignore_singletons}
\alias{feat_ignore_singletons}
\title{Feature: Ignore Singletons}
\usage{
feat_ignore_singletons()
}
\value{
The feature, which can be added to a model using `+`.
}
\description{
Mutations that are observed in just one haplotype ('singletons') are often
regarded as likely candidates for sequencing errors. Sometimes, it can be
advantageous to exclude them from an analysis. This feature removes all
singletons from the simulated data before the summary statistics are
calculated.
}
\details{
This function assumes that a singleton is a mutation for which the derived
allele is observed exactly once in all sequences, regardless of the
population structure.
}
\examples{
model <- coal_model(2, 1) +
  feat_mutation(10) +
  feat_ignore_singletons() +
  sumstat_sfs("n_mut", transformation = sum)
# In this model, all mutations are singletons. Therefore,
# the number of mutations is 0 when removing singletons:
simulate(model)$n_mut
}
\seealso{
Other features: \code{\link{feat_growth}},
  \code{\link{feat_migration}},
  \code{\link{feat_mutation}}, \code{\link{feat_outgroup}},
  \code{\link{feat_pop_merge}},
  \code{\link{feat_recombination}},
  \code{\link{feat_selection}},
  \code{\link{feat_size_change}},
  \code{\link{feat_unphased}}
}

