% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_pop_merge.R
\name{feat_pop_merge}
\alias{feat_pop_merge}
\title{Feature: Population Merge}
\usage{
feat_pop_merge(time, pop_source, pop_target, locus_group = "all")
}
\arguments{
\item{time}{The time at which the merge occurs.}

\item{pop_source}{The population from which all lines are moved.
This is the newly created population in the speciation event.}

\item{pop_target}{The population to which the lines are moved. This is
the population in which the speciation event occurs.}

\item{locus_group}{The loci for which this features is used. Can either be
\code{"all"} (default), in which case the feature is used for simulating
all loci, or a numeric vector. In the latter case, the feature is only
used for the loci added in \code{locus_} commands  with the corresponding
index starting from 1 in order in which the commands where added to the
model. For example, if a model has
\code{locus_single(10) + locus_averaged(10, 11) + locus_single(12)} and
this argument is \code{c(2, 3)}, than the feature is used for all but
the first locus (that is locus 2 - 12).}
}
\value{
The feature, which can be added to a model created with
  \code{\link{coal_model}} using \code{+}.
}
\description{
Backwards in time, this feature merges one population into another.
Forwards in time, this corresponds to a speciation event.
}
\details{
In addition to the merge, the growth rate of and all migration rates from
the source population will be set to 0 at the time of the merge to mimic
a speciation event forwards in time. Technically, \code{pop_source} is
still present in the model, but not used unless migration to the population
is manually enabled.
}
\examples{
# Two population which merge after 0.5 time units:
model <- coal_model(c(25,25), 1) +
  feat_pop_merge(0.5, 2, 1) +
  feat_mutation(5) +
  sumstat_tajimas_d()
simulate(model)

# An standard isolation-with-migration model:
model_iwm <- model +
  feat_migration(.75, symmetric = TRUE)
simulate(model_iwm)
}
\seealso{
For creating a model: \code{\link{coal_model}}

Other features: 
\code{\link{feat_growth}()},
\code{\link{feat_ignore_singletons}()},
\code{\link{feat_migration}()},
\code{\link{feat_mutation}()},
\code{\link{feat_outgroup}()},
\code{\link{feat_recombination}()},
\code{\link{feat_selection}()},
\code{\link{feat_size_change}()},
\code{\link{feat_unphased}()}
}
\concept{features}
