% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_statvalues.R
\name{format_bf}
\alias{format_bf}
\title{Format Bayes factors}
\usage{
format_bf(
  x,
  digits1 = 1,
  digits2 = 2,
  cutoff = NULL,
  label = "BF",
  italics = TRUE,
  subscript = "10",
  type = "md"
)
}
\arguments{
\item{x}{BayesFactor object or vector of numeric Bayes factor values.}

\item{digits1}{Number of digits after the decimal for Bayes factors > 1.}

\item{digits2}{Number of digits after the decimal for Bayes factors < 1.}

\item{cutoff}{Cutoff for using \verb{_BF_~10~ > <cutoff>} or
\verb{_BF_~10~ < 1 / <cutoff>} (value must be > 1).}

\item{label}{Character string for label before Bayes factor. Default is BF.
Set \code{label = ""} to return just the formatted Bayes factor value with no
label or operator (\code{=}, \code{<}, \code{>}).}

\item{italics}{Logical value (default = TRUE) for whether label should be
italicized (\emph{BF} or BF).}

\item{subscript}{Subscript to include with \emph{BF} label (\code{"10"}, \code{"01"}, or
\code{""} for no subscript).}

\item{type}{Type of formatting (\code{"md"} = markdown, \code{"latex"} = LaTeX).}
}
\value{
A character string that includes label (by default \emph{BF}~10~) and then the
Bayes factor formatted in Markdown or LaTeX. If Bayes factor is above or
below \code{cutoff}, \verb{_BF_~10~ > <cutoff>} or \verb{_BF_~10~ < 1 / <cutoff>} is used.
}
\description{
\code{format_bf()} can input either a
\href{https://cran.r-project.org/package=BayesFactor}{{BayesFactor}}
object or a vector of Bayes factor values. By default, this function rounds
Bayes factors greater than 1 to one decimal place and Bayes factors less
than 1 to two decimal places. Values greater than 1000 or less than 1/1000
are formatted using scientific notation. Cutoffs can be set that format the
values as greater than or less than the cutoffs (e.g., BF > 1000 or
BF < 0.001). Numbers of digits, cutoffs, italics, and label subscripts are
all customizable.
}
\examples{
# Format BFBayesfactor objects from {BayesFactor} package
format_bf(BayesFactor::lmBF(mpg ~ am, data = mtcars))

# Format Bayes factors > 1
format_bf(12.4444)

# Bayes factors > 1000 will use scientific notation
format_bf(1244.44)

# Control digits for Bayes factors > 1 with digits1
format_bf(1244.44, digits1 = 3)

# Control cutoff for output
format_bf(1244.44, cutoff = 10000)

# Format Bayes factors < 1
format_bf(0.111)

# Bayes factors < 0.001 will use scientific notation
format_bf(0.0001)

# Control digits for Bayes factors < 1 with digits2
format_bf(0.111, digits2 = 3)

# Control cutoff for output
format_bf(0.001, cutoff = 100)

# Return only Bayes factor value (no label)
format_bf(12.4444, label = "")

# Format for LaTeX
format_bf(12.4444, type = "latex")
}
\seealso{
Other functions for printing statistical objects: 
\code{\link{format_corr}()},
\code{\link{format_stats}()},
\code{\link{format_stats.BFBayesFactor}()},
\code{\link{format_stats.aov}()},
\code{\link{format_stats.easycorrelation}()},
\code{\link{format_stats.htest}()},
\code{\link{format_stats.lm}()},
\code{\link{format_stats.lmerModLmerTest}()},
\code{\link{format_stats.merMod}()},
\code{\link{format_ttest}()}
}
\concept{functions for printing statistical objects}
