#' HIV
#'
#' Microbiome abundances (60 taxa and 155 individuals) from an HIV study (Noguera-Julian et al. 2016).
#'
#' @format The dataset contains three objects:
#' \describe{
#'   \item{x_HIV}{microbiome abundance matrix for 155 individuals (rows) and 60 genera (columns)}
#'   \item{y_HIV}{a factor, specifying if the individual is HIV positive or (\code{Pos}) or negative (\code{Neg}).}
#'   \item{MSM_HIV}{a factor, indicating sexual preferences: \code{MSM} (\emph{Men who have Sex with Men}) or not (\code{nonMSM}).}
#' }
#' @docType data
#' @name HIV
#' @references \doi{10.1016/j.ebiom.2016.01.032}
#' @keywords data
NULL

#' HIV
#'
#' Microbiome abundances (60 taxa and 155 individuals) from an HIV study (Noguera-Julian et al. 2016).
#'
#' @format The dataset contains three objects:
#' \describe{
#'   \item{x_HIV}{microbiome abundance matrix for 155 individuals (rows) and 60 genera (columns)}
#'   \item{y_HIV}{a factor, specifying if the individual is HIV positive or (\code{Pos}) or negative (\code{Neg}).}
#'   \item{MSM_HIV}{a factor, indicating sexual preferences: \code{MSM} (\emph{Men who have Sex with Men}) or not (\code{nonMSM}).}
#' }
#' @docType data
#' @name x_HIV
#' @references \doi{10.1016/j.ebiom.2016.01.032}
#' @keywords data
NULL

#' HIV
#'
#' Microbiome abundances (60 taxa and 155 individuals) from an HIV study (Noguera-Julian et al. 2016).
#'
#' @format The dataset contains three objects:
#' \describe{
#'   \item{x_HIV}{microbiome abundance matrix for 155 individuals (rows) and 60 genera (columns)}
#'   \item{y_HIV}{a factor, specifying if the individual is HIV positive or (\code{Pos}) or negative (\code{Neg}).}
#'   \item{MSM_HIV}{a factor, indicating sexual preferences: \code{MSM} (\emph{Men who have Sex with Men}) or not (\code{nonMSM}).}
#' }
#' @docType data
#' @name y_HIV
#' @references \doi{10.1016/j.ebiom.2016.01.032}
#' @keywords data
NULL

#' HIV
#'
#' Microbiome abundances (60 taxa and 155 individuals) from an HIV study (Noguera-Julian et al. 2016).
#'
#' @format The dataset contains three objects:
#' \describe{
#'   \item{x_HIV}{microbiome abundance matrix for 155 individuals (rows) and 60 genera (columns)}
#'   \item{y_HIV}{a factor, specifying if the individual is HIV positive or (\code{Pos}) or negative (\code{Neg}).}
#'   \item{MSM_HIV}{a factor, indicating sexual preferences: \code{MSM} (\emph{Men who have Sex with Men}) or not (\code{nonMSM}).}
#' }
#' @docType data
#' @name MSM_HIV
#' @references \doi{10.1016/j.ebiom.2016.01.032}
#' @keywords data
NULL



#' sCD14
#'
#' Microbiome composition (60 taxa and 151 individuals) and inflammatory parameter sCD14
#' from an HIV study (Noguera-Julian et al. 2016).
#' A dataset containing the number of counts of 60 different genera in a group
#' of 151 samples (including HIV - infected and non - infected patients).
#'
#' @format The dataset contains two objects:
#' \describe{
#'   \item{x_sCD14}{microbiome abundance matrix for 151 individuals (rows) and 60 genera (columns)}
#'   \item{y_sCD14}{a \code{numeric} variable with the value of the inflammation parameter sCD14 for each sample}
#' }
#' @name sCD14
#' @docType data
#' @references Rivera-Pinto et al. (2018) Balances: a new perspective for microbiome analysis. mSystems 3 (4)
#' @keywords data
NULL

#' sCD14
#'
#' Microbiome composition (60 taxa and 151 individuals) and inflammatory parameter sCD14
#' from an HIV study (Noguera-Julian et al. 2016).
#' A dataset containing the number of counts of 60 different genera in a group
#' of 151 samples (including HIV - infected and non - infected patients).
#'
#' @format The dataset contains two objects:
#' \describe{
#'   \item{x_sCD14}{microbiome abundance matrix for 151 individuals (rows) and 60 genera (columns)}
#'   \item{y_sCD14}{a \code{numeric} variable with the value of the inflammation parameter sCD14 for each sample}
#' }
#' @name x_sCD14
#' @docType data
#' @references Rivera-Pinto et al. (2018) Balances: a new perspective for microbiome analysis. mSystems 3 (4)
#' @keywords data
NULL

#' sCD14
#'
#' Microbiome composition (60 taxa and 151 individuals) and inflammatory parameter sCD14
#' from an HIV study (Noguera-Julian et al. 2016).
#' A dataset containing the number of counts of 60 different genera in a group
#' of 151 samples (including HIV - infected and non - infected patients).
#'
#' @format The dataset contains two objects:
#' \describe{
#'   \item{x_sCD14}{microbiome abundance matrix for 151 individuals (rows) and 60 genera (columns)}
#'   \item{y_sCD14}{a \code{numeric} variable with the value of the inflammation parameter sCD14 for each sample}
#' }
#' @name y_sCD14
#' @docType data
#' @references Rivera-Pinto et al. (2018) Balances: a new perspective for microbiome analysis. mSystems 3 (4)
#' @keywords data
NULL

#' Crohn
#'
#' Microbiome composition at genus level from a Crohn's disease study: 48 taxa and 975 individuals
#' (662 patients with Crohn`s disease and 313 controls)
#'
#'
#'
#' @format The dataset contains two objects:
#' \describe{
#'   \item{x_Crohn}{microbiome abundance matrix for 975 individuals (rows) and 48 genera (columns)}
#'   \item{y_Crohn}{a \code{factor}, indicating if the sample corresponds to a case (\emph{CD}) or a control (\emph{no}).}
#' }
#' @name Crohn
#' @docType data
#' @references \doi{10.1016/j.chom.2014.02.005}
#' @keywords data
NULL

#' Crohn
#'
#' Microbiome composition at genus level from a Crohn's disease study: 48 taxa and 975 individuals
#' (662 patients with Crohn`s disease and 313 controls)
#'
#'
#'
#' @format The dataset contains two objects:
#' \describe{
#'   \item{x_Crohn}{microbiome abundance matrix for 975 individuals (rows) and 48 genera (columns)}
#'   \item{y_Crohn}{a \code{factor}, indicating if the sample corresponds to a case (\emph{CD}) or a control (\emph{no}).}
#' }
#' @name x_Crohn
#' @docType data
#' @references \doi{10.1016/j.chom.2014.02.005}
#' @keywords data
NULL

#' Crohn
#'
#' Microbiome composition at genus level from a Crohn's disease study: 48 taxa and 975 individuals
#' (662 patients with Crohn`s disease and 313 controls)
#'
#'
#'
#' @format The dataset contains two objects:
#' \describe{
#'   \item{x_Crohn}{microbiome abundance matrix for 975 individuals (rows) and 48 genera (columns)}
#'   \item{y_Crohn}{a \code{factor}, indicating if the sample corresponds to a case (\emph{CD}) or a control (\emph{no}).}
#' }
#' @name y_Crohn
#' @docType data
#' @references \doi{10.1016/j.chom.2014.02.005}
#' @keywords data
NULL

#' data_survival
#'
#' Survival Data simulated from the Crohn's disease original study: 48 taxa and 150 individuals
#'
#'
#'
#' @format The dataset contains three objects:
#' \describe{
#'   \item{x}{microbiome abundance matrix for 150 individuals (rows) and 48 genera (columns)}
#'   \item{Event}{a \code{numeric}, event occurrence. Vector (type: numeric or logical) specifying 0 or FALSE for no event occurrence, and 1 or TRUE for event occurrence.}
#'   \item{Event_time}{a \code{numeric}, time to event or follow up time for right censored data. Must be a vector (type:numeric) specifying time to event for each sample for right censored data.}
#' }
#' @name x
#' @docType data
#' @references \doi{10.1016/j.chom.2014.02.005}
#' @keywords data
NULL


#' data_survival
#'
#' Survival Data simulated from the Crohn's disease original study: 48 taxa and 150 individuals
#'
#'
#'
#' @format The dataset contains three objects:
#' \describe{
#'   \item{x}{microbiome abundance matrix for 150 individuals (rows) and 48 genera (columns)}
#'   \item{Event}{a \code{numeric}, event occurrence. Vector (type: numeric or logical) specifying 0 or FALSE for no event occurrence, and 1 or TRUE for event occurrence.}
#'   \item{Event_time}{a \code{numeric}, time to event or follow up time for right censored data. Must be a vector (type:numeric) specifying time to event for each sample for right censored data.}
#' }
#' @name Event
#' @docType data
#' @references \doi{10.1016/j.chom.2014.02.005}
#' @keywords data
NULL

#' data_survival
#'
#' Survival Data simulated from the Crohn's disease original study: 48 taxa and 150 individuals
#'
#'
#'
#' @format The dataset contains three objects:
#' \describe{
#'   \item{x}{microbiome abundance matrix for 150 individuals (rows) and 48 genera (columns)}
#'   \item{Event}{a \code{numeric}, event occurrence. Vector (type: numeric or logical) specifying 0 or FALSE for no event occurrence, and 1 or TRUE for event occurrence.}
#'   \item{Event_time}{a \code{numeric}, time to event or follow up time for right censored data. Must be a vector (type:numeric) specifying time to event for each sample for right censored data.}
#' }
#' @name Event_time
#' @docType data
#' @references \doi{10.1016/j.chom.2014.02.005}
#' @keywords data
NULL



#' ecam_filtered
#'
#' Microbiome composition at genus level from Early childhood and the microbiome (ECAM) study (Bokulich et al. 2016).
#' Metadata and microbiome data were downloaded from https://github.com/caporaso-lab/longitudinal-notebooks.
#' Filtered data contains information on 42 children and 37 taxa.
#'
#'
#' @format The dataset contains three objects:
#' \describe{
#'   \item{x_ecam}{microbiome abundance matrix in long format (873 rows) and 37 genera (columns)}
#'   \item{taxanames}{vector containing the taxonomy of the 37 taxa}
#'   \item{metadata}{matrix with information on the individuals at the observation time}
#' }
#' @name ecam_filtered
#' @docType data
#' @references Bokulich et al. (2016). Antibiotics, birth mode, and diet shape microbiome maturation during early life. Sci Transl Med 8:343
#' @keywords data
NULL

#' ecam_filtered
#'
#' Microbiome composition at genus level from Early childhood and the microbiome (ECAM) study (Bokulich et al. 2016).
#' Metadata and microbiome data were downloaded from https://github.com/caporaso-lab/longitudinal-notebooks.
#' Filtered data contains information on 42 children and 37 taxa.
#'
#'
#' @format The dataset contains three objects:
#' \describe{
#'   \item{x_ecam}{microbiome abundance matrix in long format (873 rows) and 37 genera (columns)}
#'   \item{taxanames}{vector containing the taxonomy of the 37 taxa}
#'   \item{metadata}{matrix with information on the individuals at the observation time}
#' }
#' @name x_ecam
#' @docType data
#' @references Bokulich et al. (2016). Antibiotics, birth mode, and diet shape microbiome maturation during early life. Sci Transl Med 8:343
#' @keywords data
NULL

#' ecam_filtered
#'
#' Microbiome composition at genus level from Early childhood and the microbiome (ECAM) study (Bokulich et al. 2016).
#' Metadata and microbiome data were downloaded from https://github.com/caporaso-lab/longitudinal-notebooks.
#' Filtered data contains information on 42 children and 37 taxa.
#'
#'
#' @format The dataset contains three objects:
#' \describe{
#'   \item{x_ecam}{microbiome abundance matrix in long format (873 rows) and 37 genera (columns)}
#'   \item{taxanames}{vector containing the taxonomy of the 37 taxa}
#'   \item{metadata}{matrix with information on the individuals at the observation time}
#' }
#' @name taxanames
#' @docType data
#' @references Bokulich et al. (2016). Antibiotics, birth mode, and diet shape microbiome maturation during early life. Sci Transl Med 8:343
#' @keywords data
NULL

#' ecam_filtered
#'
#' Microbiome composition at genus level from Early childhood and the microbiome (ECAM) study (Bokulich et al. 2016).
#' Metadata and microbiome data were downloaded from https://github.com/caporaso-lab/longitudinal-notebooks.
#' Filtered data contains information on 42 children and 37 taxa.
#'
#'
#' @format The dataset contains three objects:
#' \describe{
#'   \item{x_ecam}{microbiome abundance matrix in long format (873 rows) and 37 genera (columns)}
#'   \item{taxanames}{vector containing the taxonomy of the 37 taxa}
#'   \item{metadata}{matrix with information on the individuals at the observation time}
#' }
#' @name metadata
#' @docType data
#' @references Bokulich et al. (2016). Antibiotics, birth mode, and diet shape microbiome maturation during early life. Sci Transl Med 8:343
#' @keywords data
NULL

