% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{add_ranks}
\alias{add_ranks}
\title{Add abundance ranks}
\usage{
add_ranks(df, abundance.var)
}
\arguments{
\item{df}{A data frame containing a single record per species with its abundance}

\item{abundance.var}{The name of the abundance column}
}
\value{
The add_ranks function returns a data frame with the following
  additional column:
  \itemize{
    \item{rank: }{A numeric column with the species rank; a rank of 1
    indicates the species was most abundant in that time period. All species
    that are not present in that time period have the rank value S+1 where S
    is the number of species in the sample.
    }
  }
}
\description{
Rank species by abundance, by specified grouping. Species with
  zero abundance receive rank S+1, where S is the total number of species in
  the group.
}
