function(numgrd,numplt,numspc,grdtyp,grdlen,width,variab,grdprd,alphad,
         pdist,sdist,skew,hiecon,cmpasy,cmpphy,maxtot,noise,slack,autlin)
{
    rndplt <- function (numplt,numgrd,grdlen,grdprd)
    {
        centrd <- matrix(0,nrow=numplt,ncol=numgrd)
        pltprd <- rep(0,numplt)
        tmp <- .Fortran('rndplt',
            as.integer(numplt),
            as.integer(numgrd),
            centrd=as.double(centrd),
            as.double(grdlen),
            as.double(grdprd),
            pltprd=as.double(pltprd))
        centrd <- matrix(tmp$centrd,ncol=numgrd)
        pltprd <- tmp$pltprd
        plot.out <- list(centrd=centrd,pltprd=pltprd)
        invisible(plot.out)
    }

    fixplt <- function (numplt,numgrd,grdlen,grdprd)
    {
        centrd <- matrix(0,nrow=numplt,ncol=numgrd)
        pltprd <- rep(0,numplt)
        numpts <- rep(0,numgrd)
        index <- rep(0,numgrd)
        tmp <- .Fortran('fixplt',
            as.integer(numplt),
            as.integer(numgrd),
            as.double(grdlen),
            as.double(grdprd),
            centrd=as.double(centrd),
            pltprd=as.double(pltprd),
            numpts=as.integer(numpts),
            as.integer(index))
        mat<- matrix(tmp$centrd,ncol=numgrd)
        mat <- mat[1:prod(tmp$numpts),]
        plot.out <- list(centrd=mat,pltprd=tmp$pltprd[1:prod(tmp$numpts)])
        invisible(plot.out)
    }

    rndspc <- function (numspc,numgrd,grdlen,alphad,width,variab,grdtyp,skew,hiecon)
    {
        maxabu <- rep(0,numspc)
        spcamp <- array(0,dim=c(numspc,numgrd,5))

        tmp <- .Fortran('rndspc',
            as.integer(numspc),
            as.integer(numgrd),
            spcamp=as.double(spcamp),
            maxabu=as.double(maxabu),
            as.double(grdlen),
            as.double(alphad),
            as.double(width),
            as.double(variab),
            as.integer(grdtyp),
            as.double(skew),
            as.double(hiecon))
        spc.out <- list(spcamp=array(tmp$spcamp,dim=c(numspc,numgrd,5)),maxabu=tmp$maxabu)
        invisible(spc.out)
    }

    fixspc <- function (numspc,numgrd,grdlen,width,variab,grdtyp,skew,hiecon)
    {
        spcamp <- array(0,dim=c(numspc,numgrd,5))
        maxabu <- rep(0,numspc)
        numpts <- rep(0,numgrd)
        index <- rep(0,numgrd)
    
        tmp <- .Fortran('fixspc',
            as.integer(numspc),
            as.integer(numgrd),
            spcamp=as.double(spcamp),
            maxabu=as.double(maxabu),
            as.double(grdlen),
            as.double(width),
            as.double(variab),
            as.integer(grdtyp),
            as.double(skew),
            as.double(hiecon),
            numpts=as.integer(numpts),
            as.integer(index))
        spcamp <- array(tmp$spcamp,dim=c(numspc,numgrd,5))
        spcamp <- spcamp[1:prod(tmp$numpts),,]
        maxabu <- tmp$maxabu[1:prod(tmp$numpts)]
        spc.out <- list(spcamp=spcamp,maxabu=maxabu)
        invisible(spc.out)
    }

    totphy <- function(numplt,numspc,numgrd,noise,slack,cmpasy,cmpphy,
                       centrd=plot$centrd,spcamp=spc$spcamp,
                       argmnt=autinfo$argmnt,grdlst=autinfo$grdlst,numper=autinfo$numper,
                       count=autinfo$count,maxabu=spc$maxabu,pltprd=plot$pltprd)
    {
        physio <- matrix(0,nrow=numspc,ncol=numgrd+10)
        abunda <- matrix(0,nrow=numplt,ncol=numspc)
        diff <- rep(0,numspc)

        tmp <- .Fortran('totphy',
            as.integer(numplt),
            as.integer(numspc),
            as.integer(numgrd),
            as.double(centrd),
            as.double(spcamp),
            as.double(physio),
            as.integer(argmnt),
            as.integer(grdlst),
            as.integer(numper),
            as.integer(count),
            as.double(maxabu),
            abunda=as.double(abunda),
            as.double(pltprd),
            as.double(noise),
            as.double(slack),
            as.double(maxtot),
            as.double(cmpasy),
            as.double(cmpphy),
            as.double(diff))
        abunda <- matrix(tmp$abunda,nrow=numplt)
        abunda 
    }

    autpar <- function (line) 
    {
        argmnt <- rep(0,10)
        grdlst <- matrix(0,nrow=10,ncol=10)
        numper <- rep(0,10)
        count <- 0

        tmp <- .Fortran('autpar',
            line,
            argmnt=as.integer(argmnt),
            grdlst=as.integer(grdlst),
            numper=as.integer(numper),
            count=as.integer(count))
        grdlst <- matrix(tmp$grdlst,ncol=10)
        out <- list(argmnt=tmp$argmnt,grdlst=grdlst,numper=tmp$numper,count=tmp$count)
        invisible(out)
    }

    auteco <- function (nusmpc=numspc,numgrd=numgrd,argmnt=autinfo$argmnt,
                        grdlst=autinfo$grdlst,numper=autinfo$numper,count=autinfo$count,physio=physio)
    {
        .Fortran('auteco',
            as.integer(numspc),
            as.integer(numgrd),
            as.integer(argmnt),
            as.integer(grdlst),
            as.integer(numper),
            as.integer(count),
            as.double(physio))
    }

    if (missing(numgrd)) numgrd <- as.numeric(readline(' enter the number of gradients                   [1-10] : '))
    if (numgrd <= 0 | numgrd > 10) {
        cat('\n You can only enter anumber between 1 and 10\n')
        numgrd <- as.numeric(readline(' enter the number of gradients                   [1-10] : '))
    }

    if (missing(grdtyp)) grdtyp <- rep(NULL,numgrd)
    else if (length(grdtyp) != numgrd) stop('You must specify a gradient type for each gradient')
    grdtyp[grdtyp=='E' | grdtyp =='e'] <- 1
    grdtyp[grdtyp=='R' | grdtyp =='r'] <- 2
    
    if (!any(is.character(grdtyp))) stop('Gradient types must be either E or R')

    if (missing(grdlen)) grdlen <- rep(0,numgrd)
    else if (length(grdlen) != numgrd) stop('You must specify a gradient length for each gradient')    

    if (missing(width))  width <- rep(0,numgrd)
    else if (length(width) != numgrd) stop('You must specify a mean species amplitude for each gradient') 

    if (missing(variab)) variab <- rep(0,numgrd)
    else if (length(variab) != numgrd) stop('You must specify species amplitude variability for each gradient') 

    if (missing(grdprd)) grdprd <- rep(0,numgrd)
    else if (length(grdtyp) != numgrd) stop('You must specify the gradient productivity for each gradient')

    if (missing(alphad)) alphad <- rep(0,numgrd)
    else if (length(alphad) != numgrd) stop('You must specify the gradient alpha diversity for each gradient')
    
    for (i in 1:as.numeric(numgrd)) {
        if (is.null(grdtyp[i])) {
            cat(paste('\n enter gradient type for gradient ',i,'\n'))
            resp <- readline(' enter e for environment or r for resource     [e or r] : ')
            if (resp == 'e' || resp == 'E') grdtyp[i] <- 1
            else if (resp == 'r' || resp == 'R') grdtyp[i] <- 2
            else {
                cat('\n You can only enter e or r\n')
                cat(paste('\n enter gradient type for gradient ',i,'\n'))
                resp <- readline(' enter e for environment or r for resource     [e or r] : ')
                if (resp == 'e' || resp == 'E') grdtyp[i] <- 1
                else grdtyp[i] <- 2
            }
        }

        if (grdlen[i] == 0) {
            grdlen[i] <- as.numeric(readline(paste(' enter gradient length for gradient ',i,'       [10-1000] : ')))
            if (grdlen[i] < 10 | grdlen[i] > 1000) {
                cat('\n Enter a number between 10 and 1000\n')
                grdlen[i] <- as.numeric(readline(paste(' enter gradient length for gradient ',i,'       [10-1000] : ')))
            }
        }

        if (width[i] == 0) {
            cat('\n enter the mean width of species amplitudes\n')
            width[i] <-  as.numeric(readline('      reasonable values are ~[0.25-3 x gradient length] : '))
        }

        if (variab[i] == 0) {
            variab[i] <- as.numeric(readline(' enter the variability in percent                [0-50] : '))
            if (variab[i] < 0 | variab[i] > 100) {
                cat('\n enter a number between 0 and 50\n')
                variab[i] <- as.numeric(readline(' enter the variability in percent                [0-50] : '))
            }
        }
                    
        if (grdprd[i] == 0) {
            grdprd[i] <- as.numeric(readline(' enter the productivity response in percent     [0-200] : '))
            if (grdprd[i] < 0 | grdprd[i] > 200) {
                cat('\n enter a number between 0 and 200\n')
                grdprd[i] <- as.numeric(readline(' enter the productivity response in percent     [0-200] : '))
            }
        }

        if (alphad[i] == 0) {
            alphad[i] <- as.numeric(readline(' enter the trend in alpha-diversity           [0.5-2.0] : '))
            if (alphad[i] < 0.5 | alphad[i] > 2.0) {
                cat('\n enter a number between 0.5 and 2.0\n')
                alphad[i] <- as.numeric(readline(' enter the trend in alpha-diversity           [0.5-2.0] : '))
            }    
        }
    }

    if (missing(numplt)) {
        numplt <- as.numeric(readline('\n enter the number of plots                      [1-500] : '))
        if (numplt <= 0 | numplt > 500) {
            cat('\n enter a number between 1 and 500\n')
            numplt <- as.numeric(readline('\n enter the number of plots                      [1-500] : '))
        }    
    }

    if (missing(pdist)) {
        pdist  <- readline(' random or grid plot locations                 [r or g] :  ')
        if (pdist == 'r' | pdist == 'R') {
            plot <- rndplt(numplt,numgrd,grdlen,grdprd)
        }
        else {
            plot <- fixplt(numplt,numgrd,grdlen,grdprd)
        }
    } 
    else {
        if (pdist != 'r' && pdist != 'R' && pdist != 'g' && pdist != 'G') 
            stop ('The plot distribution must be R (random) or G (grid)')
        else if (pdist == 'r' || pdist == 'R') plot <- rndplt(numplt,numgrd,grdlen,grdprd)
        else plot <- fixplt(numplt,numgrd,grdlen,grdprd)
    }

    if (missing(numspc)) {
        numspc <- as.numeric(readline('\n enter the number of species                    [1-500] : '))
        if (numspc < 1 | numspc > 500) {
            cat('\n enter a number between 1 and 500\n')
            numspc <- as.numeric(readline('\n enter the number of species                    [1-500] : '))
        }
    }

    if (missing(skew)) {
        skew   <- as.numeric(readline(' enter the skew                             [1.00-4.00] : '))
        if (skew < 1.0 | skew > 4.0) {
            cat('\n enter a number between 1.0 and 4.0\n')
            skew   <- as.numeric(readline(' enter the skew                             [1.00-4.00] : '))
        }
    }

    if (missing(hiecon)) {
        hiecon <- as.numeric(readline(' enter the amplitude/abundance correlation  [0.00-1.00] : '))
        if (hiecon < 0.0 | hiecon > 1.0) {
            cat('\n enter a number between 0.0 and 1.0\n')
            hiecon <- as.numeric(readline(' enter the amplitude/abundance correlation  [0.00-1.00] : '))
        }
    }

    if (missing(sdist)) {
        sdist  <- readline(' random or grid species modes                  [r or g] : ')
        if (sdist == 'r' | sdist == 'R') {
            spc <- rndspc(numspc,numgrd,grdlen,alphad,width,variab,grdtyp,skew,hiecon)
        }    
        else {
            spc <- fixspc(numspc,numgrd,grdlen,width,variab,grdtyp,skew,hiecon)
        }
    }
    else {
        if (sdist != 'r' && sdist != 'R' && sdist != 'G' && sdist != 'g')
            stop ('The species distribution must be R (random) or G (grid)')
        else if (sdist == 'r' || sdist == 'R') spc <- rndspc(numspc,numgrd,grdlen,alphad,width,variab,grdtyp,skew,hiecon)
        else spc <- fixspc(numspc,numgrd,grdlen,width,variab,grdtyp,skew,hiecon)
    }

    if (missing(cmpasy)) {
        cmpasy <- as.numeric(readline(' enter the competition asymmetry            [1.00-3.00] : '))
        if (cmpasy < 1.0 | cmpasy > 3.0) {
            cat('\n enter a number between 1.0 and 3.0\n')
            cmpasy <- as.numeric(readline(' enter the competition asymmetry            [1.00-3.00] : '))
        }
    }

    if (missing(cmpphy)) {
        cmpphy <- as.numeric(readline(' enter the physiological competition coeff. [1.00-3.00] : '))
        if (cmpphy < 1.0 | cmpphy > 3.0) {
            cat('\n enter a number between 1.0 and 3.0\n')
            cmpphy <- as.numeric(readline(' enter the physiological competition coeff. [1.00-3.00] : '))
        }
    }

    if (missing(maxtot)) {
        yorn   <- readline(' standardize mean total plot abundance?        [y or n] : ')
        if (yorn == 'y' | yorn == 'Y') {
          maxtot <- as.numeric(readline(' enter the standard total percent cover        [10-500] : '))
          if (maxtot < 10 | maxtot > 500) {
              cat('\n enter a number between 10 and 500\n')
              maxtot <- as.numeric(readline(' enter the standard total percent cover        [10-500] : '))
          }
        }
        else {
          maxtot <- 0
        }
    }

    if (missing(noise)) {
        noise  <- as.numeric(readline(' enter the noise in percent                     [0-100] : '))
        if (noise < 0 | noise > 100) {
            cat('\n enter a number between 0 and 100\n')
            noise  <- as.numeric(readline(' enter the noise in percent                     [0-100] : '))
        }
    }

    if (missing(slack)) {
        slack  <- as.numeric(readline(' enter the slack as a fraction              [0.00-1.00] : '))
        if (slack < 0.0 | slack > 1.0) {
            cat('\n enter a number between 0.0 and 1.0\n')
            slack  <- as.numeric(readline(' enter the slack as a fraction              [0.00-1.00] : '))
        }
    }
    
    if (missing(autlin)) {
        autlin <- readline(' enter the autecological function\n : ')
    }
 
    autinfo <- autpar(autlin)

    abunda <- totphy(numplt,numspc,numgrd,noise,slack,cmpasy,cmpphy)

    params <- list(numplt=numplt,numspc=numspc,numgrd=numgrd,grdtyp=grdtyp,grdlen=grdlen,
                          width=width,variab=variab,grdprd=grdprd,alphad=alphad,
                          skew=skew,aacorr=hiecon,cmpasy=cmpasy,cmpphy=cmpphy,
                          pltdst=pdist,spcdst=sdist,funct=autlin,noise,slack=slack)
    site <- matrix(plot$centrd,nrow=numplt)
    veg <- matrix(abunda,ncol=numspc)
    spcamp <- array(spc$spcamp,dim=c(numspc,numgrd,5))
    maxabu <- spc$maxabu
    pltprd <- plot$pltprd 

    out <- list(params=params,site=site,veg=veg,spcamp=spcamp,maxabu=maxabu,pltprd=pltprd)
    class(out) <- 'coenoflex'
    invisible(out)
}
