### Regression tests for helper functions

set.seed(290875)
library("coin")
isequal <- coin:::isequal
options(useFancyQuotes = FALSE)


###
### Test the 'is' family of functions
###


is_factor_y <- coin:::is_factor_y
is_factor_x <- coin:::is_factor_x
is_ordered_y <- coin:::is_ordered_y
is_ordered_x <- coin:::is_ordered_x
is_unordered_y <- coin:::is_unordered_y
is_unordered_x <- coin:::is_unordered_x
is_numeric_y <- coin:::is_numeric_y
is_numeric_x <- coin:::is_numeric_x
is_censored_y <- coin:::is_censored_y
is_censored_x <- coin:::is_censored_x
is_2sample <- coin:::is_2sample
is_Ksample <- coin:::is_Ksample
is_corr <- coin:::is_corr
is_contingency <- coin:::is_contingency
is_contingency_2x2 <- coin:::is_contingency_2x2
is_singly_ordered <- coin:::is_singly_ordered
is_doubly_ordered <- coin:::is_doubly_ordered
is_ordered <- coin:::is_ordered

### Example data
f2 <- sample(gl(2, 10))
f4 <- sample(gl(4, 5))
o2 <- as.ordered(f2)
o4 <- as.ordered(f4)
n1 <- sample(1:20)
c1 <- Surv(n1, sample(0:1, 20, replace = TRUE))

### Numeric vs. numeric
it <- independence_test(n1 ~ n1)
stopifnot(identical(is_factor_y(it@statistic),        FALSE))
stopifnot(identical(is_factor_x(it@statistic),        FALSE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       TRUE))
stopifnot(identical(is_numeric_x(it@statistic),       TRUE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         FALSE))
stopifnot(identical(is_corr(it@statistic),            TRUE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Numeric vs. censored
it <- independence_test(n1 ~ c1)
stopifnot(identical(is_factor_y(it@statistic),        FALSE))
stopifnot(identical(is_factor_x(it@statistic),        FALSE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       TRUE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      TRUE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         FALSE))
stopifnot(identical(is_corr(it@statistic),            TRUE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Numeric vs. unordered 2-level factor
it <- independence_test(n1 ~ f2)
stopifnot(identical(is_factor_y(it@statistic),        FALSE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     TRUE))
stopifnot(identical(is_numeric_y(it@statistic),       TRUE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         TRUE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Numeric vs. unordered 4-level factor
it <- independence_test(n1 ~ f4)
stopifnot(identical(is_factor_y(it@statistic),        FALSE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     TRUE))
stopifnot(identical(is_numeric_y(it@statistic),       TRUE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Numeric vs. ordered 2-level factor
it <- independence_test(n1 ~ o2)
stopifnot(identical(is_factor_y(it@statistic),        FALSE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       TRUE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       TRUE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         TRUE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Numeric vs. ordered 4-level factor
it <- independence_test(n1 ~ o4)
stopifnot(identical(is_factor_y(it@statistic),        FALSE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       TRUE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       TRUE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Censored vs. numeric
it <- independence_test(c1 ~ n1)
stopifnot(identical(is_factor_y(it@statistic),        FALSE))
stopifnot(identical(is_factor_x(it@statistic),        FALSE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       TRUE))
stopifnot(identical(is_censored_y(it@statistic),      TRUE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         FALSE))
stopifnot(identical(is_corr(it@statistic),            TRUE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Censored vs. censored
it <- independence_test(c1 ~ c1)
stopifnot(identical(is_factor_y(it@statistic),        FALSE))
stopifnot(identical(is_factor_x(it@statistic),        FALSE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      TRUE))
stopifnot(identical(is_censored_x(it@statistic),      TRUE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         FALSE))
stopifnot(identical(is_corr(it@statistic),            TRUE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Censored vs. unordered 2-level factor
it <- independence_test(c1 ~ f2)
stopifnot(identical(is_factor_y(it@statistic),        FALSE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     TRUE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      TRUE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         TRUE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Censored vs. unordered 4-level factor
it <- independence_test(c1 ~ f4)
stopifnot(identical(is_factor_y(it@statistic),        FALSE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     TRUE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      TRUE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Censored vs. ordered 2-level factor
it <- independence_test(c1 ~ o2)
stopifnot(identical(is_factor_y(it@statistic),        FALSE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       TRUE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      TRUE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         TRUE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Censored vs. ordered 4-level factor
it <- independence_test(c1 ~ o4)
stopifnot(identical(is_factor_y(it@statistic),        FALSE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       TRUE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      TRUE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Unordered 2-level factor vs. numeric
it <- independence_test(f2 ~ n1)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        FALSE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     TRUE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       TRUE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         FALSE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Unordered 2-level factor vs. censored
it <- independence_test(f2 ~ c1)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        FALSE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     TRUE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      TRUE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         FALSE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Unordered 2-level factor vs. unordered 2-level factor
it <- independence_test(f2 ~ f2)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     TRUE))
stopifnot(identical(is_unordered_x(it@statistic),     TRUE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         TRUE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), TRUE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Unordered 2-level factor vs. unordered 4-level factor
it <- independence_test(f2 ~ f4)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     TRUE))
stopifnot(identical(is_unordered_x(it@statistic),     TRUE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Unordered 2-level factor vs. ordered 2-level factor
it <- independence_test(f2 ~ o2)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       TRUE))
stopifnot(identical(is_unordered_y(it@statistic),     TRUE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         TRUE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), TRUE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE)) # By convention
stopifnot(identical(is_doubly_ordered(it@statistic),  TRUE))  # By convention
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Unordered 2-level factor vs. ordered 4-level factor
it <- independence_test(f2 ~ o4)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       TRUE))
stopifnot(identical(is_unordered_y(it@statistic),     TRUE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE)) # By convention
stopifnot(identical(is_doubly_ordered(it@statistic),  TRUE))  # By convention
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Unordered 4-level factor vs. numeric
it <- independence_test(f4 ~ n1)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        FALSE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     TRUE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       TRUE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         FALSE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Unordered 4-level factor vs. censored
it <- independence_test(f4 ~ c1)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        FALSE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     TRUE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      TRUE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         FALSE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Unordered 4-level factor vs. unordered 2-level factor
it <- independence_test(f4 ~ f2)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     TRUE))
stopifnot(identical(is_unordered_x(it@statistic),     TRUE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         TRUE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Unordered 4-level factor vs. unordered 4-level factor
it <- independence_test(f4 ~ f4)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     TRUE))
stopifnot(identical(is_unordered_x(it@statistic),     TRUE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         FALSE))

### Unordered 4-level factor vs. ordered 2-level factor
it <- independence_test(f4 ~ o2)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       TRUE))
stopifnot(identical(is_unordered_y(it@statistic),     TRUE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         TRUE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Unordered 4-level factor vs. ordered 4-level factor
it <- independence_test(f4 ~ o4)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       FALSE))
stopifnot(identical(is_ordered_x(it@statistic),       TRUE))
stopifnot(identical(is_unordered_y(it@statistic),     TRUE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Ordered 2-level factor vs. numeric
it <- independence_test(o2 ~ n1)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        FALSE))
stopifnot(identical(is_ordered_y(it@statistic),       TRUE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       TRUE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         FALSE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Ordered 2-level factor vs. censored
it <- independence_test(o2 ~ c1)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        FALSE))
stopifnot(identical(is_ordered_y(it@statistic),       TRUE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      TRUE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         FALSE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Ordered 2-level factor vs. unordered 2-level factor
it <- independence_test(o2 ~ f2)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       TRUE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     TRUE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         TRUE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), TRUE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE)) # By convention
stopifnot(identical(is_doubly_ordered(it@statistic),  TRUE))  # By convention
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Ordered 2-level factor vs. unordered 4-level factor
it <- independence_test(o2 ~ f4)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       TRUE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     TRUE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Ordered 2-level factor vs. ordered 2-level factor
it <- independence_test(o2 ~ o2)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       TRUE))
stopifnot(identical(is_ordered_x(it@statistic),       TRUE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         TRUE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), TRUE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Ordered 2-level factor vs. ordered 4-level factor
it <- independence_test(o2 ~ o4)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       TRUE))
stopifnot(identical(is_ordered_x(it@statistic),       TRUE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Ordered 4-level factor vs. numeric
it <- independence_test(o4 ~ n1)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        FALSE))
stopifnot(identical(is_ordered_y(it@statistic),       TRUE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       TRUE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         FALSE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Ordered 4-level factor vs. censored
it <- independence_test(o4 ~ c1)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        FALSE))
stopifnot(identical(is_ordered_y(it@statistic),       TRUE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      TRUE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         FALSE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     FALSE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Ordered 4-level factor vs. unordered 2-level factor
it <- independence_test(o4 ~ f2)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       TRUE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     TRUE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         TRUE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE)) # By convention
stopifnot(identical(is_doubly_ordered(it@statistic),  TRUE))  # By convention
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Ordered 4-level factor vs. unordered 4-level factor
it <- independence_test(o4 ~ f4)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       TRUE))
stopifnot(identical(is_ordered_x(it@statistic),       FALSE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     TRUE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_doubly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Ordered 4-level factor vs. ordered 2-level factor
it <- independence_test(o4 ~ o2)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       TRUE))
stopifnot(identical(is_ordered_x(it@statistic),       TRUE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         TRUE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))

### Ordered 4-level factor vs. ordered 4-level factor
it <- independence_test(o4 ~ o4)
stopifnot(identical(is_factor_y(it@statistic),        TRUE))
stopifnot(identical(is_factor_x(it@statistic),        TRUE))
stopifnot(identical(is_ordered_y(it@statistic),       TRUE))
stopifnot(identical(is_ordered_x(it@statistic),       TRUE))
stopifnot(identical(is_unordered_y(it@statistic),     FALSE))
stopifnot(identical(is_unordered_x(it@statistic),     FALSE))
stopifnot(identical(is_numeric_y(it@statistic),       FALSE))
stopifnot(identical(is_numeric_x(it@statistic),       FALSE))
stopifnot(identical(is_censored_y(it@statistic),      FALSE))
stopifnot(identical(is_censored_x(it@statistic),      FALSE))
stopifnot(identical(is_2sample(it@statistic),         FALSE))
stopifnot(identical(is_Ksample(it@statistic),         TRUE))
stopifnot(identical(is_corr(it@statistic),            FALSE))
stopifnot(identical(is_contingency(it@statistic),     TRUE))
stopifnot(identical(is_contingency_2x2(it@statistic), FALSE))
stopifnot(identical(is_singly_ordered(it@statistic),  FALSE))
stopifnot(identical(is_doubly_ordered(it@statistic),  TRUE))
stopifnot(identical(is_ordered(it@statistic),         TRUE))
