% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_formula.R
\name{construct_formula}
\alias{construct_formula}
\title{Construct an nls-compatible formula from an lm style formula}
\usage{
construct_formula(formula, data)
}
\arguments{
\item{formula}{The formula. This has the same syntax and supports the same features as the 
formula in \code{lm}. See examples.}

\item{data}{A data frame containing the data of the variables in the formula.}
}
\value{
A list of three elements:
\itemize{
  \item model_formula - An nls compatible formula
  \item model_data - The modelling set created (inlcuding dummy variables, if any)
  \item x_param_names - The names of the parameters

}
}
\description{
Construct an nls-compatible formula from an lm style formula
}
\details{
\code{construct_formula} creates the parameters needed for the formula to be compatible with nls
style functions. It also creates and returns the modelling set.

\code{construct_formula} will make syntactically valid names (if applicable) otherwise the 
optimizers will fail. To make these names \code{make.names} is used. Check examples.
}
\examples{
#simple syntax
construct_formula(mpg ~ hp + cyl, mtcars)

#example of make.names to create syntactically valid names
make.names('(foo/^@bar)')

#function will create syntactically valid names (if applicable) 
#otherwise the optimizers will fail
construct_formula(mpg ~ I(hp + cyl), mtcars)
construct_formula(mpg ~ (hp + cyl + disp)^3, mtcars)

}
\seealso{
\link[stats]{nls}, \link{make.names}
}

