% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_raw_image_handling.R
\name{loadImage}
\alias{loadImage}
\title{Import image and generate filtered 2D pixel array(s)}
\usage{
loadImage(path, lower = c(0, 0.55, 0), upper = c(0.24, 1, 0.24),
  hsv = TRUE, CIELab = FALSE, sample.size = 1e+05,
  ref.white = NULL)
}
\arguments{
\item{path}{Path to image (a string).}

\item{lower}{RGB or HSV triplet specifying the lower bounds for background
pixels. Default upper and lower bounds are set to values that work well for
a bright green background (RGB [0, 1, 0]).}

\item{upper}{RGB or HSV triplet specifying the upper bounds for background
pixels. Default upper and lower bounds are set to values that work well for
a bright green background (RGB [0, 1, 0]). Determining these bounds may
take some trial and error, but the following bounds may work for certain
common background colors: \itemize{ \item Black: lower=c(0, 0, 0);
upper=c(0.1, 0.1, 0.1) \item White: lower=c(0.8, 0.8, 0.8); upper=c(1, 1,
1) \item Green: lower=c(0, 0.55, 0); upper=c(0.24, 1, 0.24) \item Blue:
lower=c(0, 0, 0.55); upper=c(0.24, 0.24, 1) } If no background filtering is
needed, set bounds to some non-numeric value (\code{NULL}, \code{FALSE},
\code{"off"}, etc); any non-numeric value is interpreted as \code{NULL}.}

\item{hsv}{Logical. Should HSV pixel array also be calculated? Setting to
\code{FALSE} will shave some time off the analysis, but not much (a few
microseconds per image).}

\item{CIELab}{Logical. Should CIEL*a*b color space pixels be calculated from
RGB? Requires specification of a reference white (see details).}

\item{sample.size}{Number of pixels to be randomly sampled from filtered pixel
array for conversion. If not numeric, all pixels are converted, but this
can be time-consuming, especially for large images. See details for speed.}

\item{ref.white}{String; white reference for converting from RGB to CIEL*a*b
color space. Accepts any of the standard white references for
\code{\link[grDevices]{convertColor}} (see details).}
}
\value{
A list with original image ($original.rgb, 3D array), 2D matrix with
  background pixels removed ($filtered.rgb.2d and $filtered.hsv.2d), and path
  to the original image ($path).
}
\description{
Imports a single image and returns a list with the original image as a 3D
array, a 2D matrix with background pixels removed, and the absolute path to
the original image.
}
\details{
The upper and lower limits for background pixel elimination set the
inclusive bounds for which pixels should be ignored for the 2D arrays; while
all background pixels are ideally a single color, images photographed against
"uniform" backgrounds often contain some variation, and even segmentation
done with photo editing software will produce some variance as a result of
image compression.

The upper and lower bounds represent cutoffs: any pixel for which the first
channel falls between the first upper and lower bounds, the second channel
falls between the second upper and lower bounds, and the third channel falls
between the third upper and lower bounds, will be ignored. For example, if
you have a green pixel with RGB channel values [0.1, 0.9, 0.2], and your
upper and lower bounds were (0.2, 1, 0.2) and (0, 0.6, 0) respectively, the
pixel would be ignored because 0 <= 0.1 <= 0.2, 0.6 <= 0.9 <= 1, and 0 <= 0.2
<= 0.2. But a pixel with the RGB channel values [0.3, 0.9, 0.2] would not be
considered background because 0.3 >= 0.2.

CIEL*a*b color space requires a reference 'white light' color (dimly and
brightly lit photographs of the same object will have very different RGB
palettes, but similar Lab palettes if appropriate white references are used).
The idea here is that the apparent colors in an image depend not just on the
"absolute" color of an object (whatever that means), but also on the
available light in the scene. There are seven CIE standardized illuminants
available in \code{colordistance} (A, B, C, E, and D50, D55, and D60), but
the most common are: \itemize{ \item \code{"A"}: Standard incandescent
lightbulb \item \code{"D65"}: Average daylight \item \code{"D50"}: Direct
sunlight}

Color conversions will be highly dependent on the reference white used, which
is why no default is provided. Users should look into
\href{https://en.wikipedia.org/wiki/Standard_illuminant}{standard
illuminants} to choose an appropriate reference for a dataset.
}
\note{
The 3D array is useful for displaying the original image, while the 2D
arrays (RGB and HSV) are treated as rows of data for clustering in the rest
of the package.
}
\examples{
loadedImg <- colordistance::loadImage(system.file("extdata",
"Heliconius/Heliconius_A/Heliconius_01.jpeg", package="colordistance"),
upper=rep(1, 3), lower=rep(0.8, 3))

loadedImgNoHSV <- colordistance::loadImage(system.file("extdata",
"Heliconius/Heliconius_A/Heliconius_01.jpeg", package="colordistance"),
upper=rep(1, 3), lower=rep(0.8, 3), hsv=FALSE)

}
