% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_output_visualization.R
\name{plotHist}
\alias{plotHist}
\title{Color histogram of binned image}
\usage{
plotHist(histogram, pausing = TRUE, color.space = "rgb", ref.white,
  from = "sRGB", main = "default", ...)
}
\arguments{
\item{histogram}{A single dataframe or a list of dataframes as returned by
\code{\link{getLabHist}}, \code{\link{getLabHistList}}, or
\code{\link{extractClusters}}. First three columns must be color
coordinates and fourth column must be cluster size.}

\item{pausing}{Logical. Pause and wait for keystroke before plotting the next
histogram?}

\item{color.space}{The color space (\code{"rgb"}, \code{"hsv"}, or
\code{"lab"}) in which to plot cluster histogram.}

\item{ref.white}{The reference white passed to
\code{\link{convertColorSpace}}; must be specified if using CIE
Lab space. See \link{convertColorSpace}.}

\item{from}{Display color space of image if clustering in CIE Lab space,
probably either "sRGB" or "Apple RGB", depending on your computer.}

\item{main}{Title for plot. If \code{"default"}, the name of the cluster
histogram is used.}

\item{...}{Optional arguments passed to the \code{\link[graphics]{barplot}} function.}
}
\description{
Plots a color histogram from a dataframe as returned by
\code{\link{getImageHist}}, \code{\link{getHistList}}, or
\code{\link{extractClusters}}. Bars are colored according to the color of the
bin.
}
\examples{
color_df <- as.data.frame(matrix(rep(seq(0, 1, length.out=3), 3), nrow=3,
ncol=3))

color_df$Pct <- c(0.2, 0.5, 0.3)

colordistance::plotHist(color_df, main="Example plot")
}
