% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScaleColorPlane.R
\name{scale_color_colorplane}
\alias{scale_color_colorplane}
\alias{scale_colour_colourplane}
\alias{scale_fill_colorplane}
\alias{scale_fill_colourplane}
\title{Bivariate Color Space Projection Scale}
\usage{
scale_color_colorplane(name = waiver(), axis_title = waiver(),
  axis_title_y = waiver(), breaks = waiver(), breaks_y = waiver(),
  labels = waiver(), labels_y = waiver(), limits = NULL,
  limits_y = NULL, color_projection = "YUV", rescaler = rescale,
  oob = censor, trans = "identity", na.color = "black",
  na.value = NA_real_, guide = "colorplane", ...)

scale_fill_colorplane(name = waiver(), axis_title = waiver(),
  axis_title_y = waiver(), breaks = waiver(), breaks_y = waiver(),
  labels = waiver(), labels_y = waiver(), limits = NULL,
  limits_y = NULL, color_projection = "YUV", rescaler = rescale,
  oob = censor, trans = "identity", na.color = "black",
  na.value = NA_real_, guide = "colorplane", ...)
}
\arguments{
\item{name}{Character string or expression to be used as guide title.
Defaults to "Color Key" or "Fill Color Key" to match the scale function
used.}

\item{axis_title, axis_title_y}{Character strings or expressions indicating
the horizontal and vertical axis titles in the guide, respectively. If
\code{NULL}, the title is not shown. By default (\link[ggplot2]{waiver}),
the name of the scale or the name of the variable mapped to the aesthetic.}

\item{breaks}{One of: \itemize{
  \item \code{NULL} for no breaks
  \item \code{waiver()} for the default breaks computed by the
    transformation object
  \item A numeric vector of positions
  \item A function that takes the limits as input and returns breaks
    as output
}}

\item{breaks_y}{As \code{breaks}, but for vertical axis (i.e. \code{color2}
or \code{fill2})}

\item{labels}{One of: \itemize{
  \item \code{NULL} for no labels
  \item \code{waiver()} for the default labels computed by the
    transformation object
  \item A character vector giving labels (must be same length as \code{breaks})
  \item A function that takes the breaks as input and returns labels
    as output
}}

\item{labels_y}{As \code{labels}, but for vertical axis (i.e. \code{color2}
or \code{fill2})}

\item{limits}{A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum.}

\item{limits_y}{As \code{limits}, but for vertical axis (i.e. \code{color2}
or \code{fill2})}

\item{color_projection}{Projection mapping to use. Either the name of an
included projection or a function that performs the projection. See
\code{\link{color_projections}}.}

\item{rescaler}{Used by diverging and n colour gradients
(i.e. \code{\link{scale_colour_gradient2}}, \code{\link{scale_colour_gradientn}}).
A function used to scale the input values to the range [0, 1].}

\item{oob}{Function that handles limits outside of the scale limits
(out of bounds). The default replaces out of bounds values with NA.}

\item{trans}{Either the name of a transformation object, or the
  object itself. Built-in transformations include "asn", "atanh",
  "boxcox", "exp", "identity", "log", "log10", "log1p", "log2",
  "logit", "probability", "probit", "reciprocal", "reverse" and "sqrt".

  A transformation object bundles together a transform, it's inverse,
  and methods for generating breaks and labels. Transformation objects
  are defined in the scales package, and are called \code{name_trans}, e.g.
  \code{\link[scales]{boxcox_trans}}. You can create your own
  transformation with \code{\link[scales]{trans_new}}.}

\item{na.color}{Character string containing a valid R color to use when
plotting missing data or data outside the limits.}

\item{na.value}{Missing values will be replaced with this value.}

\item{guide}{Name of guide object, or object itself. Defaults to
\code{\link{guide_colorplane}} designed for this scale. Behavior of other
guides with this scale is not defined.}

\item{...}{Additional arguments to pass on to \code{color_projection}
function.}
}
\description{
Maps two continuous variables into a single display color, using either the
\code{color} and \code{color2} aesthetics (\code{scale_color_colorplane}) or
the \code{fill} and \code{fill2} aesthetics (\code{scale_fill_colorplane}).
Variables mapped to \code{color} or \code{fill} are be mapped to the
horizontal component of the colorplane scale and \code{color}/\code{fill2}
are mapped to the vertical component.
}
\details{
Variable values are projected into color space to create a bivariate
gradient. The default projection maps values to the U and V components of YUV
color space. In the YUV color space, the full spectrum of chrominance (color
difference) is encoded into the U and V components and luminosity
(brightness) is encoded in the Y component. For a fixed value of Y, the
remaining U-V color space is a plane of all possible colors at that
brightness. Therefore, mapping data to this projection utilizes the full
color spectrum to provide visual discrimination between differing values.

The YUV projection colorplane scale is visually divided into four quadrants:
green when both values are small, fuchsia when both are large, orange when
the horizontal variable is small and the vertical is large, and blue when the
horizontal variable is large and the vertical is small. Values closer to the
extremes are saturated and the center of the scale, representing the
mid-point of the ranges for both variables, is grey.

Alternative color projections can be used, but may not be as interpretable.
See \code{\link{color_projections}} for information on specifying or creating
other color projections.
}
\examples{
library(ggplot2)
if(requireNamespace("mapproj")) {
  crimes <- data.frame(state = tolower(rownames(USArrests)), USArrests)
  states_map <- map_data("state")
  ggplot(crimes,
         aes(map_id = state, fill = Murder, fill2 = UrbanPop)) +
    geom_map(map = states_map) +
    scale_fill_colorplane() +
    expand_limits(x = states_map$long, y = states_map$lat) +
    coord_map()
 }
# setting upper limit for qsec causes points for higher values to plot
# as na.color (black)
ggplot(mtcars, aes(x = wt, y = mpg, color = qsec, colour2 = hp)) +
  geom_point(size = 4) +
  scale_color_colorplane(limits = c(NA, 18.9))
}
\references{
Based on \code{\link[ggplot2]{continuous_scale}}, modified 2016.
}

