% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_incove.R
\name{get_incove}
\alias{get_incove}
\title{Create an integrated co-occurrence vector (wecove)}
\usage{
get_incove(x, ordered = TRUE, repeated = TRUE,
  normalization = "none")
}
\arguments{
\item{x}{A matrix - an output of the \code{\link[=get_incoma]{get_incoma()}} function}

\item{ordered}{The type of pairs considered.
Either "ordered" (TRUE) or "unordered" (FALSE).
The default is TRUE.}

\item{repeated}{Should the repeated co-located co-occurrence matrices be used?
Either "ordered" (TRUE) or "unordered" (FALSE).
The default is TRUE.}

\item{normalization}{Should the output vector be normalized?
Either "none" or "pdf".
The "pdf" option normalizes a vector to sum to one.
The default is "none".}
}
\value{
An integrated co-occurrence vector
}
\description{
Converts an integrated co-occurrence matrix (wecoma) to
an integrated co-occurrence vector (wecove)
}
\examples{
library(comat)

data(raster_x, package = "comat")
data(raster_w, package = "comat")
x = list(raster_x, raster_w, raster_x)

incom = get_incoma(x)
incom

incov1 = get_incove(incom)
incov1

incov2 = get_incove(incom, ordered = FALSE)
incov2
}
