% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combi.R
\name{combi}
\alias{combi}
\title{Compute combinations.}
\usage{
combi(data, signalthr = 0, combithr = 1, max_length = NULL)
}
\arguments{
\item{data}{a data.frame returned by load_data().}

\item{signalthr}{a numeric that specifies the value above which a marker expression is considered positive in a given sample. Since the target of the analysis is the identification of marker combinations capable to correctly classify samples, the user should choose a signalthr that:
\itemize{
\item Positively selects most samples belonging to the case class, which must be above signalthr.
\item Negatively selects most control samples, which must be below signalthr.
}}

\item{combithr}{a numeric that specifies the necessary number of positively expressed markers (>= signalthr), in a given combination, to cosinder that combination positivelly expressed in a sample.}

\item{max_length}{an integer that specifies the max combination length that is allowed}
}
\value{
a data.frame containing how many samples of each class are "positive" for each combination.
}
\description{
A function that computes the marker combinations and counts their corresponding positive samples for each class (once thresholds are selected).
}
\details{
This function counts how many samples are 'positive' for each combination. A sample, to be considered positive for a given combination, must have a value higher than a given signal threshold (signalthr) for at least a given number of markers composing that combination (combithr).
}
\examples{
demo_data # combiroc built-in demo data (proteomics data from Zingaretti et al. 2012 - PMC3518104)


# To compute the marker combinations and count their corresponding positive samples for each class.

 combs <- combi(data= demo_data, signalthr=450, combithr=1)  # count as positive the samples with
                                                             # value >= 450 for at least 1 marker
                                                             # in the combination

}
