% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_unclassified_data.R
\name{load_unclassified_data}
\alias{load_unclassified_data}
\title{Load unclassified data.}
\usage{
load_unclassified_data(data, sep = ";", na.strings = "")
}
\arguments{
\item{data}{the name of the file which the data are to be read from.}

\item{sep}{the field separator character.}

\item{na.strings}{a character vector of strings which are to be interpreted as NA values.}
}
\value{
a data frame (data.frame) containing a representation of the data in the file.
}
\description{
A function to load datasets not yet classified. It's analogue to load_data() since it loads the same data type and performs the same format checks, with the exception of "Class" column that in unclassified data is missing.
}
\details{
The unclassified dataset to be loaded should be in text format, which can be comma, tab or semicolon separated:
\itemize{
\item The 1st column must contain unique patient/sample IDs.
\item From the 2nd column on, the dataset must contain numerical values that represent the signal corresponding to the markers abundance in each sample (marker-related columns).
\item Marker-related columns must be called with the same name of the dataset previously loaded with load_data().
Only if all the checks are passed, it reorders alphabetically the marker-related columns depending on marker names (necessary for a proper computation of combinations), and it forces "Class" as 2nd column name.
}
}
\examples{
demo_unclassified_data # combiroc built-in unclassified demo data

# save a data.frame as a csv to be load by combiroc package
file= tempfile()
write.csv2(demo_unclassified_data, file = file, row.names = FALSE)

# To load an unclassified dataset.

demo_unclassified_data <- load_unclassified_data(data= file ,
sep = ";", na.strings="" )
}
