% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment.R
\name{Experiment}
\alias{Experiment}
\title{A Comet Experiment object}
\description{
A comet experiment object can be used to modify or get information about an active
experiment. All methods documented here are the different ways to interact with an
experiment. Use \code{\link[=create_experiment]{create_experiment()}} to create a Comet experiment object.
}
\examples{
\dontrun{
library(cometr)
# Assuming you have COMET_API_KEY, COMET_WORKSPACE, COMET_PROJECT_NAME variables define
exp <- create_experiment()
exp$get_key()
exp$get_metadata()
exp$add_tags(c("test", "tag2"))
exp$get_tags()
exp$log_metric("metric1", 5)
exp$get_metric("metric1")
exp$get_metrics_summary()
exp$stop()
}

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Experiment$new()}}
\item \href{#method-get_key}{\code{Experiment$get_key()}}
\item \href{#method-get_url}{\code{Experiment$get_url()}}
\item \href{#method-get_metadata}{\code{Experiment$get_metadata()}}
\item \href{#method-archive}{\code{Experiment$archive()}}
\item \href{#method-restore}{\code{Experiment$restore()}}
\item \href{#method-delete}{\code{Experiment$delete()}}
\item \href{#method-stop}{\code{Experiment$stop()}}
\item \href{#method-log_metric}{\code{Experiment$log_metric()}}
\item \href{#method-get_metric}{\code{Experiment$get_metric()}}
\item \href{#method-get_metrics_summary}{\code{Experiment$get_metrics_summary()}}
\item \href{#method-log_graph}{\code{Experiment$log_graph()}}
\item \href{#method-get_graph}{\code{Experiment$get_graph()}}
\item \href{#method-log_parameter}{\code{Experiment$log_parameter()}}
\item \href{#method-get_parameters}{\code{Experiment$get_parameters()}}
\item \href{#method-log_other}{\code{Experiment$log_other()}}
\item \href{#method-get_other}{\code{Experiment$get_other()}}
\item \href{#method-add_tags}{\code{Experiment$add_tags()}}
\item \href{#method-get_tags}{\code{Experiment$get_tags()}}
\item \href{#method-log_html}{\code{Experiment$log_html()}}
\item \href{#method-get_html}{\code{Experiment$get_html()}}
\item \href{#method-upload_asset}{\code{Experiment$upload_asset()}}
\item \href{#method-get_asset_list}{\code{Experiment$get_asset_list()}}
\item \href{#method-get_asset}{\code{Experiment$get_asset()}}
\item \href{#method-create_symlink}{\code{Experiment$create_symlink()}}
\item \href{#method-log_git_metadata}{\code{Experiment$log_git_metadata()}}
\item \href{#method-get_git_metadata}{\code{Experiment$get_git_metadata()}}
\item \href{#method-get_git_patch}{\code{Experiment$get_git_patch()}}
\item \href{#method-get_output}{\code{Experiment$get_output()}}
\item \href{#method-log_code}{\code{Experiment$log_code()}}
\item \href{#method-get_code}{\code{Experiment$get_code()}}
\item \href{#method-log_system_details}{\code{Experiment$log_system_details()}}
\item \href{#method-get_system_details}{\code{Experiment$get_system_details()}}
\item \href{#method-set_start_end_time}{\code{Experiment$set_start_end_time()}}
\item \href{#method-print}{\code{Experiment$print()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Do not call this function directly. Use \code{create_experiment()} instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$new(
  experiment_key,
  experiment_url = NULL,
  api_key = NULL,
  keep_active = FALSE,
  log_output = FALSE,
  log_error = FALSE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_key"></a>}}
\if{latex}{\out{\hypertarget{method-get_key}{}}}
\subsection{Method \code{get_key()}}{
Get the experiment key of an experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_key()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_url"></a>}}
\if{latex}{\out{\hypertarget{method-get_url}{}}}
\subsection{Method \code{get_url()}}{
Get the URL to view an experiment in the browser.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_url()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-get_metadata}{}}}
\subsection{Method \code{get_metadata()}}{
Get an experiment's metadata.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_metadata()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-archive"></a>}}
\if{latex}{\out{\hypertarget{method-archive}{}}}
\subsection{Method \code{archive()}}{
Archive an experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$archive()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-restore"></a>}}
\if{latex}{\out{\hypertarget{method-restore}{}}}
\subsection{Method \code{restore()}}{
Restore an archived experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$restore()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
Delete an experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stop"></a>}}
\if{latex}{\out{\hypertarget{method-stop}{}}}
\subsection{Method \code{stop()}}{
Stop an experiment. Always call this method before creating a new experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$stop()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log_metric"></a>}}
\if{latex}{\out{\hypertarget{method-log_metric}{}}}
\subsection{Method \code{log_metric()}}{
Log a metric name and value. Metrics are the only items that are logged as
a full time series. However, even metrics can be throttled if too much data
(either by rate or by count) is attempted to be logged.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_metric(name, value, step = NULL, epoch = NULL, context = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{(Required) Name of the metric.}

\item{\code{value}}{(Required) Value of the metric.}

\item{\code{step}}{Step number.}

\item{\code{epoch}}{Epoch.}

\item{\code{context}}{Context.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_metric"></a>}}
\if{latex}{\out{\hypertarget{method-get_metric}{}}}
\subsection{Method \code{get_metric()}}{
Get All Metrics For Name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_metric(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{(Required) Name of metric.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_metrics_summary"></a>}}
\if{latex}{\out{\hypertarget{method-get_metrics_summary}{}}}
\subsection{Method \code{get_metrics_summary()}}{
Get an experiment's metrics summary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_metrics_summary()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log_graph"></a>}}
\if{latex}{\out{\hypertarget{method-log_graph}{}}}
\subsection{Method \code{log_graph()}}{
Log an experiment's associated model graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_graph(graph)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{graph}}{(Required) JSON representation of a graph.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_graph"></a>}}
\if{latex}{\out{\hypertarget{method-get_graph}{}}}
\subsection{Method \code{get_graph()}}{
Get an experiment's model graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_graph()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log_parameter"></a>}}
\if{latex}{\out{\hypertarget{method-log_parameter}{}}}
\subsection{Method \code{log_parameter()}}{
Log a parameter name and value. Note that you can only retrieve parameters
summary data (e.g., this is not recorded as a full time series).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_parameter(name, value, step = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{(Required) Name of the parameter.}

\item{\code{value}}{(Required) Value of the parameter.}

\item{\code{step}}{Step number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_parameters"></a>}}
\if{latex}{\out{\hypertarget{method-get_parameters}{}}}
\subsection{Method \code{get_parameters()}}{
Get an experiment's parameters summary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_parameters()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log_other"></a>}}
\if{latex}{\out{\hypertarget{method-log_other}{}}}
\subsection{Method \code{log_other()}}{
Log a key/value `other`` data (not a metric or parameter). Note
that you can only retrieve others summary data (e.g., this is
not recorded as a full time series).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_other(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{(Required) The key.}

\item{\code{value}}{(Required) The value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_other"></a>}}
\if{latex}{\out{\hypertarget{method-get_other}{}}}
\subsection{Method \code{get_other()}}{
Get an experiment's others (logged with \code{log_other()}) summary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_other()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_tags"></a>}}
\if{latex}{\out{\hypertarget{method-add_tags}{}}}
\subsection{Method \code{add_tags()}}{
Add a list of tags to an experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$add_tags(tags)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tags}}{(Required) List of tags.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_tags"></a>}}
\if{latex}{\out{\hypertarget{method-get_tags}{}}}
\subsection{Method \code{get_tags()}}{
Get an experiment's tags.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_tags()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log_html"></a>}}
\if{latex}{\out{\hypertarget{method-log_html}{}}}
\subsection{Method \code{log_html()}}{
Set (or append onto) an experiment's HTML.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_html(html, override = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{html}}{(Required) An HTML string to add to the experiment.}

\item{\code{override}}{If \code{TRUE}, override the previous HTML. If \code{FALSE}, append to it.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_html"></a>}}
\if{latex}{\out{\hypertarget{method-get_html}{}}}
\subsection{Method \code{get_html()}}{
Get an experiment's HTML.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_html()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-upload_asset"></a>}}
\if{latex}{\out{\hypertarget{method-upload_asset}{}}}
\subsection{Method \code{upload_asset()}}{
Upload a file to the experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$upload_asset(
  file,
  step = NULL,
  overwrite = NULL,
  context = NULL,
  type = NULL,
  name = NULL,
  metadata = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{(Required) Path to the file to upload.}

\item{\code{step}}{Step number.}

\item{\code{overwrite}}{If \code{TRUE}, overwrite any uploaded file with the same name.}

\item{\code{context}}{The context.}

\item{\code{type}}{The type of asset.}

\item{\code{name}}{Name of the file on comet. By default the name of the file will
match the file that you upload, but you can use this parameter to use a
different name.}

\item{\code{metadata}}{Metadata to upload along with the file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_asset_list"></a>}}
\if{latex}{\out{\hypertarget{method-get_asset_list}{}}}
\subsection{Method \code{get_asset_list()}}{
Get an experiment's asset list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_asset_list(type = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{The type of assets to retrieve (by default, all assets are returned).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_asset"></a>}}
\if{latex}{\out{\hypertarget{method-get_asset}{}}}
\subsection{Method \code{get_asset()}}{
Get an asset.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_asset(assetId)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{assetId}}{(Required) The asset ID to retrieve.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-create_symlink"></a>}}
\if{latex}{\out{\hypertarget{method-create_symlink}{}}}
\subsection{Method \code{create_symlink()}}{
Add a symlink to an experiment in another project.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$create_symlink(project_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{project_name}}{(Required) Project that the experiment to should linked to.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log_git_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-log_git_metadata}{}}}
\subsection{Method \code{log_git_metadata()}}{
Log an experiment's git metadata. This should only be called once and it can be done
automatically by enabling \code{log_git_info} in \code{\link[=create_experiment]{create_experiment()}}. This will replace
any previous git metadata that was logged.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_git_metadata(
  branch = NULL,
  origin = NULL,
  parent = NULL,
  user = NULL,
  root = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{branch}}{Git branch name.}

\item{\code{origin}}{Git repository origin.}

\item{\code{parent}}{Git commit SHA.}

\item{\code{user}}{Git username.}

\item{\code{root}}{Git root.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_git_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-get_git_metadata}{}}}
\subsection{Method \code{get_git_metadata()}}{
Get the git metadata of an experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_git_metadata()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_git_patch"></a>}}
\if{latex}{\out{\hypertarget{method-get_git_patch}{}}}
\subsection{Method \code{get_git_patch()}}{
Get the git patch of an experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_git_patch()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_output"></a>}}
\if{latex}{\out{\hypertarget{method-get_output}{}}}
\subsection{Method \code{get_output()}}{
Get an experiment's standard output and error.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_output()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log_code"></a>}}
\if{latex}{\out{\hypertarget{method-log_code}{}}}
\subsection{Method \code{log_code()}}{
Log an experiment's source code. This should only be called once and it can be done
automatically by enabling \code{log_code} in \code{\link[=create_experiment]{create_experiment()}}. This will replace
any previous code that was logged.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_code(code)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{code}}{The code to set as the source code.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_code"></a>}}
\if{latex}{\out{\hypertarget{method-get_code}{}}}
\subsection{Method \code{get_code()}}{
Get an experiment's source code.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_code()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log_system_details"></a>}}
\if{latex}{\out{\hypertarget{method-log_system_details}{}}}
\subsection{Method \code{log_system_details()}}{
Log system details. This can be done automatically by enabling \code{log_system_details}
in \code{\link[=create_experiment]{create_experiment()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$log_system_details(
  command = NULL,
  executable = NULL,
  hostname = NULL,
  installed_packages = NULL,
  gpu_static_info = NULL,
  ip = NULL,
  network_interface_ips = NULL,
  additional_system_info = NULL,
  os = NULL,
  os_packages = NULL,
  os_type = NULL,
  pid = NULL,
  user = NULL,
  r_version = NULL,
  r_version_verbose = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Script and optional arguments.}

\item{\code{executable}}{Executable.}

\item{\code{hostname}}{Hostname.}

\item{\code{installed_packages}}{List of installed R packages.}

\item{\code{gpu_static_info}}{List of GPU information, where each GPU is a \code{list()} with
fields \code{gpuIndex}, \code{name}, \code{powerLimit}, \code{totalMemory}, \code{uuid}.}

\item{\code{ip}}{IP address.}

\item{\code{network_interface_ips}}{List of network interface IPs.}

\item{\code{additional_system_info}}{List of additional parameters to log,
where each parameter is a \code{list()} with \code{key} and \code{value} pairs.}

\item{\code{os}}{Full details about operating system.}

\item{\code{os_packages}}{List of operating system packages installed.}

\item{\code{os_type}}{Operating system type.}

\item{\code{pid}}{Process ID.}

\item{\code{user}}{User.}

\item{\code{r_version}}{Short form R version.}

\item{\code{r_version_verbose}}{Long form R version.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_system_details"></a>}}
\if{latex}{\out{\hypertarget{method-get_system_details}{}}}
\subsection{Method \code{get_system_details()}}{
Get an experiment's system details.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$get_system_details()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_start_end_time"></a>}}
\if{latex}{\out{\hypertarget{method-set_start_end_time}{}}}
\subsection{Method \code{set_start_end_time()}}{
Set an experiment's start and end time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$set_start_end_time(start = NULL, end = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{start}}{Start time for the experiment (milliseconds since the Epoch)}

\item{\code{end}}{End time for the experiment (milliseconds since the Epoch)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Experiment$print()}\if{html}{\out{</div>}}
}

}
}
