% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.set.R
\name{calibrate.set}
\alias{calibrate.set}
\title{Calculate the calibrated set of idea LRs}
\usage{
calibrate.set(LR.ss, LR.ds, method = c("raw", "laplace"))
}
\arguments{
\item{LR.ss}{a vector of likelihood ratios for the comparisons of items known to be from the same source}

\item{LR.ds}{a vector of likelihood ratios for the comparisons of items known to be from different sources}

\item{method}{the method used to perform the calculation, either \code{"raw"} or \code{"laplace"}}
}
\value{
a \code{list} with two items: \describe{
\item{LR.cal.ss}{calibrated LRs for the comparison for same set}
\item{LR.cal.ds}{calibrated LRs for the comparison for different set}
}
}
\description{
Calculates and returns the calibrated set of \verb{ideal' LRs from the observed LRs using the penalised adjacent violators algorithm. This is very much a rewrite of Nico Brummer's }optloglr()` function for Matlab.
}
\details{
This is an internal function, and is not meant to be called directly. However
it has been exported just in case.
}
\references{
D. Ramos and J. Gonzalez-Rodrigues, (2008) "Cross-entropy analysis of the information in forensic speaker recognition," in Proc. IEEE Odyssey, Speaker Lang. Recognit. Workshop.
}
\seealso{
\code{\link[isotone:gpava]{isotone::gpava()}}, \code{\link[=calc.ece]{calc.ece()}}
}
\author{
David Lucy
}
