% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{cs_load_year}
\alias{cs_load_year}
\title{Create Year List Object}
\usage{
cs_load_year(path)
}
\arguments{
\item{path}{A file path}
}
\value{
A year-list object containing 12 tibbles - one per month - worth
   of crime data stored within a list.
}
\description{
\code{cs_load_year} is used to load a set of \code{.csv} files
   contained in the given directory. This should be used to load a full
   year worth of data or a partial year. There should be no more than 12
   files in a given path, and all should correspond to the same year. All
   columns will be read in as character data in order to address inconsistencies
   in how the data are created. When \link{cs_collapse} is executed, variables
   will be converted numeric when doing so is applicable.
}
\examples{
# create temporary directory
tmpdir <- tempdir()
fs::dir_create(paste0(tmpdir,"/data/"))

# load sample files into temporary directory
cs_example(path = paste0(tmpdir,"/data/"))

# prep sample files
cs_prep_year(path = paste0(tmpdir,"/data/"))

# load sample files
yearList17 <- cs_load_year(path = paste0(tmpdir,"/data/"))

# delete data
fs::dir_delete(paste0(tmpdir,"/data/"))

# print year-list object
yearList17

}
