% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule_fill_gradient2.R
\name{rule_fill_gradient2}
\alias{rule_fill_gradient2}
\title{Fill column with sequential color gradient}
\usage{
rule_fill_gradient2(
  x,
  columns,
  expression,
  low = scales::muted("red"),
  mid = "white",
  high = scales::muted("blue"),
  midpoint = NA,
  space = "Lab",
  na.value = "#7F7F7F",
  limits = NA,
  lockcells = FALSE
)
}
\arguments{
\item{x}{A condformat object, typically created with \code{\link[=condformat]{condformat()}}}

\item{columns}{A character vector with column names to be colored. Optionally
\code{\link[tidyselect:language]{tidyselect::language()}} can be used.}

\item{expression}{an expression to be evaluated with the data.
It should evaluate to a logical or an integer vector,
that will be used to determine which cells are to be colored.}

\item{low}{colour for low end of gradient.}

\item{mid}{colour for mid point}

\item{high}{colour for high end of gradient.}

\item{midpoint}{the value used for the middle color (the median by default)}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}

\item{na.value}{fill color for missing values}

\item{limits}{range of limits that the gradient should cover}

\item{lockcells}{logical value determining if no further rules should be applied to the affected cells.}
}
\value{
The condformat_tbl object, with the added formatting information
}
\description{
Fills the background color of a column using a gradient based on
the values given by an expression
}
\examples{
data(iris)
cf <- condformat(iris[c(1:5, 70:75, 120:125), ]) \%>\%
 rule_fill_gradient2(Sepal.Length) \%>\%
 rule_fill_gradient2(Species, expression=Sepal.Length - Sepal.Width)
\dontrun{
print(cf)
}

cf <- condformat(iris[c(1:5, 70:75, 120:125), ]) \%>\%
  rule_fill_gradient2("Petal.Length") \%>\%
  rule_fill_gradient2(starts_with("Sepal"), expression=Sepal.Length - Sepal.Width)
\dontrun{
print(cf)
}

}
\seealso{
Other rule: 
\code{\link{rule_css}()},
\code{\link{rule_fill_bar}()},
\code{\link{rule_fill_discrete}()},
\code{\link{rule_fill_gradient}()},
\code{\link{rule_text_bold}()},
\code{\link{rule_text_color}()}
}
\concept{rule}
