% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condpath.R
\name{condtour}
\alias{condtour}
\alias{randomPath}
\alias{kmeansPath}
\alias{pamPath}
\alias{claraPath}
\alias{fastkmedPath}
\alias{lofPath}
\alias{diffitsPath}
\alias{createPath}
\title{Tours of data space}
\usage{
randomPath(data, fits = NULL, length = 10, reorder = TRUE,
  conditionvars = NULL, ...)

kmeansPath(data, fits = NULL, length = 10, reorder = TRUE,
  conditionvars = NULL, ...)

pamPath(data, fits = NULL, length = 10, reorder = TRUE,
  conditionvars = NULL, ...)

claraPath(data, fits = NULL, length = 10, reorder = TRUE,
  conditionvars = NULL, ...)

fastkmedPath(data, fits = NULL, length = 10, reorder = TRUE,
  conditionvars = NULL, ...)

lofPath(data, fits, length = 10, reorder = TRUE,
  conditionvars = NULL, predictArgs = NULL)

diffitsPath(data, fits, length = 10, reorder = TRUE,
  conditionvars = NULL, predictArgs = NULL)

createPath(data, score, length = 10, reorder = TRUE,
  conditionvars = NULL)
}
\arguments{
\item{data}{A dataset}

\item{fits}{A model fit or list of fits}

\item{length}{The length of path returns}

\item{reorder}{If TRUE, points on the path are re-ordered so nearby points are close in the path}

\item{conditionvars}{A vector of variable names. Some tours will limit calculation to this subset of variables.}

\item{...}{other arguments, ignored}

\item{predictArgs}{a list with one entry per fit, giving arguments for CVpredict}

\item{score}{A vector of length equal to the nrows of data.}
}
\value{
A dataframe, which is the path
}
\description{
Tours of data space
}
\details{
kmeansPath works for both numeric and factors, which are converted to columns of indicators.
pamPath is not recommended for large datasets, use claraPath instead.
fits are used only in lofPath and diffitsPath.
Paths are reordered using dser from package DendSer.
}
\section{Functions}{
\itemize{
\item \code{randomPath}: Returns a random path

\item \code{kmeansPath}: Returns a path using kmeans centroids

\item \code{pamPath}: Returns a path using pam medoids from package cluster

\item \code{claraPath}: Returns a path using clara medoids from package cluster

\item \code{fastkmedPath}: Returns a path using fastkmed from package kmed

\item \code{lofPath}: Returns a path showing biggest absolute residuals from fits.

\item \code{diffitsPath}: Returns a path showing biggest difference in fits

\item \code{createPath}: Returns a path showing highest scores
}}

